/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaReferenceInner;
import java.io.IOException;
import java.util.List;

public final class SchemaReferenceListResult
implements JsonSerializable<SchemaReferenceListResult> {
    private List<SchemaReferenceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SchemaReferenceListResult.class);

    private SchemaReferenceListResult() {
    }

    public List<SchemaReferenceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SchemaReferenceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SchemaReferenceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SchemaReferenceListResult)jsonReader.readObject(reader -> {
            SchemaReferenceListResult deserializedSchemaReferenceListResult = new SchemaReferenceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSchemaReferenceListResult.value = value = reader.readArray(reader1 -> SchemaReferenceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSchemaReferenceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchemaReferenceListResult;
        });
    }
}

