/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.WorkflowsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.WorkflowInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkflowImpl;
import com.azure.resourcemanager.workloadorchestration.models.Workflow;
import com.azure.resourcemanager.workloadorchestration.models.Workflows;

public final class WorkflowsImpl
implements Workflows {
    private static final ClientLogger LOGGER = new ClientLogger(WorkflowsImpl.class);
    private final WorkflowsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public WorkflowsImpl(WorkflowsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Workflow> getWithResponse(String resourceGroupName, String contextName, String workflowName, Context context) {
        Response<WorkflowInner> inner = this.serviceClient().getWithResponse(resourceGroupName, contextName, workflowName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkflowImpl((WorkflowInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Workflow get(String resourceGroupName, String contextName, String workflowName) {
        WorkflowInner inner = this.serviceClient().get(resourceGroupName, contextName, workflowName);
        if (inner != null) {
            return new WorkflowImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String contextName, String workflowName) {
        this.serviceClient().delete(resourceGroupName, contextName, workflowName);
    }

    @Override
    public void delete(String resourceGroupName, String contextName, String workflowName, Context context) {
        this.serviceClient().delete(resourceGroupName, contextName, workflowName, context);
    }

    @Override
    public PagedIterable<Workflow> listByContext(String resourceGroupName, String contextName) {
        PagedIterable<WorkflowInner> inner = this.serviceClient().listByContext(resourceGroupName, contextName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkflowImpl((WorkflowInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workflow> listByContext(String resourceGroupName, String contextName, Context context) {
        PagedIterable<WorkflowInner> inner = this.serviceClient().listByContext(resourceGroupName, contextName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkflowImpl((WorkflowInner)((Object)inner1), this.manager()));
    }

    @Override
    public Workflow getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        return (Workflow)this.getWithResponse(resourceGroupName, contextName, workflowName, Context.NONE).getValue();
    }

    @Override
    public Response<Workflow> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        return this.getWithResponse(resourceGroupName, contextName, workflowName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        this.delete(resourceGroupName, contextName, workflowName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        this.delete(resourceGroupName, contextName, workflowName, context);
    }

    private WorkflowsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkflowImpl define(String name) {
        return new WorkflowImpl(name, this.manager());
    }
}

