/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.workloadorchestration.fluent.WorkflowsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.WorkflowInner;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkloadOrchestrationManagementClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.models.WorkflowListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WorkflowsClientImpl
implements WorkflowsClient {
    private final WorkflowsService service;
    private final WorkloadOrchestrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(WorkflowsClientImpl.class);

    WorkflowsClientImpl(WorkloadOrchestrationManagementClientImpl client) {
        this.service = (WorkflowsService)RestProxy.create(WorkflowsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkflowInner>> getWithResponseAsync(String resourceGroupName, String contextName, String workflowName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkflowInner> getAsync(String resourceGroupName, String contextName, String workflowName) {
        return this.getWithResponseAsync(resourceGroupName, contextName, workflowName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((WorkflowInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkflowInner> getWithResponse(String resourceGroupName, String contextName, String workflowName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowInner get(String resourceGroupName, String contextName, String workflowName) {
        return (WorkflowInner)((Object)this.getWithResponse(resourceGroupName, contextName, workflowName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, "application/json", "application/json", resource, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WorkflowInner>, WorkflowInner> beginCreateOrUpdateAsync(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, contextName, workflowName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WorkflowInner.class), (Type)((Object)WorkflowInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WorkflowInner>, WorkflowInner> beginCreateOrUpdate(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, contextName, workflowName, resource);
        return this.client.getLroResult(response, (Type)((Object)WorkflowInner.class), (Type)((Object)WorkflowInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WorkflowInner>, WorkflowInner> beginCreateOrUpdate(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, contextName, workflowName, resource, context);
        return this.client.getLroResult(response, (Type)((Object)WorkflowInner.class), (Type)((Object)WorkflowInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkflowInner> createOrUpdateAsync(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, contextName, workflowName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowInner createOrUpdate(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource) {
        return (WorkflowInner)((Object)this.beginCreateOrUpdate(resourceGroupName, contextName, workflowName, resource).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowInner createOrUpdate(String resourceGroupName, String contextName, String workflowName, WorkflowInner resource, Context context) {
        return (WorkflowInner)((Object)this.beginCreateOrUpdate(resourceGroupName, contextName, workflowName, resource, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, "application/json", "application/json", properties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WorkflowInner>, WorkflowInner> beginUpdateAsync(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, contextName, workflowName, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WorkflowInner.class), (Type)((Object)WorkflowInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WorkflowInner>, WorkflowInner> beginUpdate(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, contextName, workflowName, properties);
        return this.client.getLroResult(response, (Type)((Object)WorkflowInner.class), (Type)((Object)WorkflowInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WorkflowInner>, WorkflowInner> beginUpdate(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, contextName, workflowName, properties, context);
        return this.client.getLroResult(response, (Type)((Object)WorkflowInner.class), (Type)((Object)WorkflowInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WorkflowInner> updateAsync(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties) {
        return this.beginUpdateAsync(resourceGroupName, contextName, workflowName, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowInner update(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties) {
        return (WorkflowInner)((Object)this.beginUpdate(resourceGroupName, contextName, workflowName, properties).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowInner update(String resourceGroupName, String contextName, String workflowName, WorkflowInner properties, Context context) {
        return (WorkflowInner)((Object)this.beginUpdate(resourceGroupName, contextName, workflowName, properties, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String contextName, String workflowName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String contextName, String workflowName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String contextName, String workflowName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String contextName, String workflowName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, contextName, workflowName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String contextName, String workflowName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, contextName, workflowName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String contextName, String workflowName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, contextName, workflowName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String contextName, String workflowName) {
        return this.beginDeleteAsync(resourceGroupName, contextName, workflowName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String contextName, String workflowName) {
        this.beginDelete(resourceGroupName, contextName, workflowName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String contextName, String workflowName, Context context) {
        this.beginDelete(resourceGroupName, contextName, workflowName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowInner>> listByContextSinglePageAsync(String resourceGroupName, String contextName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByContext(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowListResult)res.getValue()).value(), ((WorkflowListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WorkflowInner> listByContextAsync(String resourceGroupName, String contextName) {
        return new PagedFlux(() -> this.listByContextSinglePageAsync(resourceGroupName, contextName), nextLink -> this.listByContextNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<WorkflowInner> listByContextSinglePage(String resourceGroupName, String contextName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<WorkflowListResult> res = this.service.listByContextSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowListResult)res.getValue()).value(), ((WorkflowListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<WorkflowInner> listByContextSinglePage(String resourceGroupName, String contextName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<WorkflowListResult> res = this.service.listByContextSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowListResult)res.getValue()).value(), ((WorkflowListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkflowInner> listByContext(String resourceGroupName, String contextName) {
        return new PagedIterable(() -> this.listByContextSinglePage(resourceGroupName, contextName), nextLink -> this.listByContextNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkflowInner> listByContext(String resourceGroupName, String contextName, Context context) {
        return new PagedIterable(() -> this.listByContextSinglePage(resourceGroupName, contextName, context), nextLink -> this.listByContextNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowInner>> listByContextNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByContextNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowListResult)res.getValue()).value(), ((WorkflowListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<WorkflowInner> listByContextNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<WorkflowListResult> res = this.service.listByContextNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowListResult)res.getValue()).value(), ((WorkflowListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<WorkflowInner> listByContextNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<WorkflowListResult> res = this.service.listByContextNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowListResult)res.getValue()).value(), ((WorkflowListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="WorkloadOrchestrationManagementClientWorkflows")
    public static interface WorkflowsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<WorkflowInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") WorkflowInner var9, Context var10);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") WorkflowInner var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") WorkflowInner var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") WorkflowInner var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowListResult>> listByContext(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<WorkflowListResult> listByContextSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowListResult>> listByContextNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<WorkflowListResult> listByContextNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

