/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.WorkflowVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.WorkflowVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkflowVersionImpl;
import com.azure.resourcemanager.workloadorchestration.models.WorkflowVersion;
import com.azure.resourcemanager.workloadorchestration.models.WorkflowVersions;

public final class WorkflowVersionsImpl
implements WorkflowVersions {
    private static final ClientLogger LOGGER = new ClientLogger(WorkflowVersionsImpl.class);
    private final WorkflowVersionsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public WorkflowVersionsImpl(WorkflowVersionsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<WorkflowVersion> getWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, Context context) {
        Response<WorkflowVersionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, contextName, workflowName, versionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkflowVersionImpl((WorkflowVersionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public WorkflowVersion get(String resourceGroupName, String contextName, String workflowName, String versionName) {
        WorkflowVersionInner inner = this.serviceClient().get(resourceGroupName, contextName, workflowName, versionName);
        if (inner != null) {
            return new WorkflowVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String contextName, String workflowName, String versionName) {
        this.serviceClient().delete(resourceGroupName, contextName, workflowName, versionName);
    }

    @Override
    public void delete(String resourceGroupName, String contextName, String workflowName, String versionName, Context context) {
        this.serviceClient().delete(resourceGroupName, contextName, workflowName, versionName, context);
    }

    @Override
    public PagedIterable<WorkflowVersion> listByWorkflow(String resourceGroupName, String contextName, String workflowName) {
        PagedIterable<WorkflowVersionInner> inner = this.serviceClient().listByWorkflow(resourceGroupName, contextName, workflowName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkflowVersionImpl((WorkflowVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WorkflowVersion> listByWorkflow(String resourceGroupName, String contextName, String workflowName, Context context) {
        PagedIterable<WorkflowVersionInner> inner = this.serviceClient().listByWorkflow(resourceGroupName, contextName, workflowName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkflowVersionImpl((WorkflowVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public WorkflowVersion getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return (WorkflowVersion)this.getWithResponse(resourceGroupName, contextName, workflowName, versionName, Context.NONE).getValue();
    }

    @Override
    public Response<WorkflowVersion> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, contextName, workflowName, versionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.delete(resourceGroupName, contextName, workflowName, versionName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.delete(resourceGroupName, contextName, workflowName, versionName, context);
    }

    private WorkflowVersionsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkflowVersionImpl define(String name) {
        return new WorkflowVersionImpl(name, this.manager());
    }
}

