/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.TargetsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ResolvedConfigurationInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionVersionInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.TargetInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResolvedConfigurationImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionVersionImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.TargetImpl;
import com.azure.resourcemanager.workloadorchestration.models.InstallSolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.RemoveRevisionParameter;
import com.azure.resourcemanager.workloadorchestration.models.ResolvedConfiguration;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateParameter;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersion;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersionParameter;
import com.azure.resourcemanager.workloadorchestration.models.Target;
import com.azure.resourcemanager.workloadorchestration.models.Targets;
import com.azure.resourcemanager.workloadorchestration.models.UninstallSolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.UpdateExternalValidationStatusParameter;

public final class TargetsImpl
implements Targets {
    private static final ClientLogger LOGGER = new ClientLogger(TargetsImpl.class);
    private final TargetsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public TargetsImpl(TargetsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Target> getByResourceGroupWithResponse(String resourceGroupName, String targetName, Context context) {
        Response<TargetInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, targetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TargetImpl((TargetInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Target getByResourceGroup(String resourceGroupName, String targetName) {
        TargetInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, targetName);
        if (inner != null) {
            return new TargetImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String targetName) {
        this.serviceClient().delete(resourceGroupName, targetName);
    }

    @Override
    public void delete(String resourceGroupName, String targetName, Boolean forceDelete, Context context) {
        this.serviceClient().delete(resourceGroupName, targetName, forceDelete, context);
    }

    @Override
    public PagedIterable<Target> listByResourceGroup(String resourceGroupName) {
        PagedIterable<TargetInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TargetImpl((TargetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Target> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<TargetInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TargetImpl((TargetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Target> list() {
        PagedIterable<TargetInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TargetImpl((TargetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Target> list(Context context) {
        PagedIterable<TargetInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TargetImpl((TargetInner)((Object)inner1), this.manager()));
    }

    @Override
    public void installSolution(String resourceGroupName, String targetName, InstallSolutionParameter body) {
        this.serviceClient().installSolution(resourceGroupName, targetName, body);
    }

    @Override
    public void installSolution(String resourceGroupName, String targetName, InstallSolutionParameter body, Context context) {
        this.serviceClient().installSolution(resourceGroupName, targetName, body, context);
    }

    @Override
    public void uninstallSolution(String resourceGroupName, String targetName, UninstallSolutionParameter body) {
        this.serviceClient().uninstallSolution(resourceGroupName, targetName, body);
    }

    @Override
    public void uninstallSolution(String resourceGroupName, String targetName, UninstallSolutionParameter body, Context context) {
        this.serviceClient().uninstallSolution(resourceGroupName, targetName, body, context);
    }

    @Override
    public void removeRevision(String resourceGroupName, String targetName, RemoveRevisionParameter body) {
        this.serviceClient().removeRevision(resourceGroupName, targetName, body);
    }

    @Override
    public void removeRevision(String resourceGroupName, String targetName, RemoveRevisionParameter body, Context context) {
        this.serviceClient().removeRevision(resourceGroupName, targetName, body, context);
    }

    @Override
    public ResolvedConfiguration resolveConfiguration(String resourceGroupName, String targetName, SolutionTemplateParameter body) {
        ResolvedConfigurationInner inner = this.serviceClient().resolveConfiguration(resourceGroupName, targetName, body);
        if (inner != null) {
            return new ResolvedConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ResolvedConfiguration resolveConfiguration(String resourceGroupName, String targetName, SolutionTemplateParameter body, Context context) {
        ResolvedConfigurationInner inner = this.serviceClient().resolveConfiguration(resourceGroupName, targetName, body, context);
        if (inner != null) {
            return new ResolvedConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SolutionVersion reviewSolutionVersion(String resourceGroupName, String targetName, SolutionTemplateParameter body) {
        SolutionVersionInner inner = this.serviceClient().reviewSolutionVersion(resourceGroupName, targetName, body);
        if (inner != null) {
            return new SolutionVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SolutionVersion reviewSolutionVersion(String resourceGroupName, String targetName, SolutionTemplateParameter body, Context context) {
        SolutionVersionInner inner = this.serviceClient().reviewSolutionVersion(resourceGroupName, targetName, body, context);
        if (inner != null) {
            return new SolutionVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SolutionVersion publishSolutionVersion(String resourceGroupName, String targetName, SolutionVersionParameter body) {
        SolutionVersionInner inner = this.serviceClient().publishSolutionVersion(resourceGroupName, targetName, body);
        if (inner != null) {
            return new SolutionVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SolutionVersion publishSolutionVersion(String resourceGroupName, String targetName, SolutionVersionParameter body, Context context) {
        SolutionVersionInner inner = this.serviceClient().publishSolutionVersion(resourceGroupName, targetName, body, context);
        if (inner != null) {
            return new SolutionVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SolutionVersion updateExternalValidationStatus(String resourceGroupName, String targetName, UpdateExternalValidationStatusParameter body) {
        SolutionVersionInner inner = this.serviceClient().updateExternalValidationStatus(resourceGroupName, targetName, body);
        if (inner != null) {
            return new SolutionVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SolutionVersion updateExternalValidationStatus(String resourceGroupName, String targetName, UpdateExternalValidationStatusParameter body, Context context) {
        SolutionVersionInner inner = this.serviceClient().updateExternalValidationStatus(resourceGroupName, targetName, body, context);
        if (inner != null) {
            return new SolutionVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Target getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        return (Target)this.getByResourceGroupWithResponse(resourceGroupName, targetName, Context.NONE).getValue();
    }

    @Override
    public Response<Target> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, targetName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        Boolean localForceDelete = null;
        this.delete(resourceGroupName, targetName, localForceDelete, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Boolean forceDelete, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        this.delete(resourceGroupName, targetName, forceDelete, context);
    }

    private TargetsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public TargetImpl define(String name) {
        return new TargetImpl(name, this.manager());
    }
}

