/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.TargetInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.InstallSolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.RemoveRevisionParameter;
import com.azure.resourcemanager.workloadorchestration.models.ResolvedConfiguration;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateParameter;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersion;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersionParameter;
import com.azure.resourcemanager.workloadorchestration.models.Target;
import com.azure.resourcemanager.workloadorchestration.models.TargetProperties;
import com.azure.resourcemanager.workloadorchestration.models.UninstallSolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.UpdateExternalValidationStatusParameter;
import java.util.Collections;
import java.util.Map;

public final class TargetImpl
implements Target,
Target.Definition,
Target.Update {
    private TargetInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String targetName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public TargetProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TargetInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public TargetImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Target create() {
        this.innerObject = this.serviceManager.serviceClient().getTargets().createOrUpdate(this.resourceGroupName, this.targetName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Target create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTargets().createOrUpdate(this.resourceGroupName, this.targetName, this.innerModel(), context);
        return this;
    }

    TargetImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new TargetInner();
        this.serviceManager = serviceManager;
        this.targetName = name;
    }

    @Override
    public TargetImpl update() {
        return this;
    }

    @Override
    public Target apply() {
        this.innerObject = this.serviceManager.serviceClient().getTargets().update(this.resourceGroupName, this.targetName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Target apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTargets().update(this.resourceGroupName, this.targetName, this.innerModel(), context);
        return this;
    }

    TargetImpl(TargetInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.targetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "targets");
    }

    @Override
    public Target refresh() {
        this.innerObject = (TargetInner)((Object)this.serviceManager.serviceClient().getTargets().getByResourceGroupWithResponse(this.resourceGroupName, this.targetName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Target refresh(Context context) {
        this.innerObject = (TargetInner)((Object)this.serviceManager.serviceClient().getTargets().getByResourceGroupWithResponse(this.resourceGroupName, this.targetName, context).getValue());
        return this;
    }

    @Override
    public void installSolution(InstallSolutionParameter body) {
        this.serviceManager.targets().installSolution(this.resourceGroupName, this.targetName, body);
    }

    @Override
    public void installSolution(InstallSolutionParameter body, Context context) {
        this.serviceManager.targets().installSolution(this.resourceGroupName, this.targetName, body, context);
    }

    @Override
    public void uninstallSolution(UninstallSolutionParameter body) {
        this.serviceManager.targets().uninstallSolution(this.resourceGroupName, this.targetName, body);
    }

    @Override
    public void uninstallSolution(UninstallSolutionParameter body, Context context) {
        this.serviceManager.targets().uninstallSolution(this.resourceGroupName, this.targetName, body, context);
    }

    @Override
    public void removeRevision(RemoveRevisionParameter body) {
        this.serviceManager.targets().removeRevision(this.resourceGroupName, this.targetName, body);
    }

    @Override
    public void removeRevision(RemoveRevisionParameter body, Context context) {
        this.serviceManager.targets().removeRevision(this.resourceGroupName, this.targetName, body, context);
    }

    @Override
    public ResolvedConfiguration resolveConfiguration(SolutionTemplateParameter body) {
        return this.serviceManager.targets().resolveConfiguration(this.resourceGroupName, this.targetName, body);
    }

    @Override
    public ResolvedConfiguration resolveConfiguration(SolutionTemplateParameter body, Context context) {
        return this.serviceManager.targets().resolveConfiguration(this.resourceGroupName, this.targetName, body, context);
    }

    @Override
    public SolutionVersion reviewSolutionVersion(SolutionTemplateParameter body) {
        return this.serviceManager.targets().reviewSolutionVersion(this.resourceGroupName, this.targetName, body);
    }

    @Override
    public SolutionVersion reviewSolutionVersion(SolutionTemplateParameter body, Context context) {
        return this.serviceManager.targets().reviewSolutionVersion(this.resourceGroupName, this.targetName, body, context);
    }

    @Override
    public SolutionVersion publishSolutionVersion(SolutionVersionParameter body) {
        return this.serviceManager.targets().publishSolutionVersion(this.resourceGroupName, this.targetName, body);
    }

    @Override
    public SolutionVersion publishSolutionVersion(SolutionVersionParameter body, Context context) {
        return this.serviceManager.targets().publishSolutionVersion(this.resourceGroupName, this.targetName, body, context);
    }

    @Override
    public SolutionVersion updateExternalValidationStatus(UpdateExternalValidationStatusParameter body) {
        return this.serviceManager.targets().updateExternalValidationStatus(this.resourceGroupName, this.targetName, body);
    }

    @Override
    public SolutionVersion updateExternalValidationStatus(UpdateExternalValidationStatusParameter body, Context context) {
        return this.serviceManager.targets().updateExternalValidationStatus(this.resourceGroupName, this.targetName, body, context);
    }

    @Override
    public TargetImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public TargetImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public TargetImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public TargetImpl withProperties(TargetProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public TargetImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

