/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionVersionImpl;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersion;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersions;

public final class SolutionVersionsImpl
implements SolutionVersions {
    private static final ClientLogger LOGGER = new ClientLogger(SolutionVersionsImpl.class);
    private final SolutionVersionsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public SolutionVersionsImpl(SolutionVersionsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SolutionVersion> getWithResponse(String resourceGroupName, String targetName, String solutionName, String solutionVersionName, Context context) {
        Response<SolutionVersionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, targetName, solutionName, solutionVersionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SolutionVersionImpl((SolutionVersionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SolutionVersion get(String resourceGroupName, String targetName, String solutionName, String solutionVersionName) {
        SolutionVersionInner inner = this.serviceClient().get(resourceGroupName, targetName, solutionName, solutionVersionName);
        if (inner != null) {
            return new SolutionVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String targetName, String solutionName, String solutionVersionName) {
        this.serviceClient().delete(resourceGroupName, targetName, solutionName, solutionVersionName);
    }

    @Override
    public void delete(String resourceGroupName, String targetName, String solutionName, String solutionVersionName, Context context) {
        this.serviceClient().delete(resourceGroupName, targetName, solutionName, solutionVersionName, context);
    }

    @Override
    public PagedIterable<SolutionVersion> listBySolution(String resourceGroupName, String targetName, String solutionName) {
        PagedIterable<SolutionVersionInner> inner = this.serviceClient().listBySolution(resourceGroupName, targetName, solutionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionVersionImpl((SolutionVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SolutionVersion> listBySolution(String resourceGroupName, String targetName, String solutionName, Context context) {
        PagedIterable<SolutionVersionInner> inner = this.serviceClient().listBySolution(resourceGroupName, targetName, solutionName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionVersionImpl((SolutionVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public SolutionVersion getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        String solutionVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (solutionVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return (SolutionVersion)this.getWithResponse(resourceGroupName, targetName, solutionName, solutionVersionName, Context.NONE).getValue();
    }

    @Override
    public Response<SolutionVersion> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        String solutionVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (solutionVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, targetName, solutionName, solutionVersionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        String solutionVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (solutionVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.delete(resourceGroupName, targetName, solutionName, solutionVersionName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        String solutionVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (solutionVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.delete(resourceGroupName, targetName, solutionName, solutionVersionName, context);
    }

    private SolutionVersionsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SolutionVersionImpl define(String name) {
        return new SolutionVersionImpl(name, this.manager());
    }
}

