/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersion;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersionProperties;

public final class SolutionVersionImpl
implements SolutionVersion,
SolutionVersion.Definition,
SolutionVersion.Update {
    private SolutionVersionInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String targetName;
    private String solutionName;
    private String solutionVersionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SolutionVersionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SolutionVersionInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SolutionVersionImpl withExistingSolution(String resourceGroupName, String targetName, String solutionName) {
        this.resourceGroupName = resourceGroupName;
        this.targetName = targetName;
        this.solutionName = solutionName;
        return this;
    }

    @Override
    public SolutionVersion create() {
        this.innerObject = this.serviceManager.serviceClient().getSolutionVersions().createOrUpdate(this.resourceGroupName, this.targetName, this.solutionName, this.solutionVersionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SolutionVersion create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSolutionVersions().createOrUpdate(this.resourceGroupName, this.targetName, this.solutionName, this.solutionVersionName, this.innerModel(), context);
        return this;
    }

    SolutionVersionImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new SolutionVersionInner();
        this.serviceManager = serviceManager;
        this.solutionVersionName = name;
    }

    @Override
    public SolutionVersionImpl update() {
        return this;
    }

    @Override
    public SolutionVersion apply() {
        this.innerObject = this.serviceManager.serviceClient().getSolutionVersions().update(this.resourceGroupName, this.targetName, this.solutionName, this.solutionVersionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SolutionVersion apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSolutionVersions().update(this.resourceGroupName, this.targetName, this.solutionName, this.solutionVersionName, this.innerModel(), context);
        return this;
    }

    SolutionVersionImpl(SolutionVersionInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.targetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "targets");
        this.solutionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "solutions");
        this.solutionVersionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "versions");
    }

    @Override
    public SolutionVersion refresh() {
        this.innerObject = (SolutionVersionInner)((Object)this.serviceManager.serviceClient().getSolutionVersions().getWithResponse(this.resourceGroupName, this.targetName, this.solutionName, this.solutionVersionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SolutionVersion refresh(Context context) {
        this.innerObject = (SolutionVersionInner)((Object)this.serviceManager.serviceClient().getSolutionVersions().getWithResponse(this.resourceGroupName, this.targetName, this.solutionName, this.solutionVersionName, context).getValue());
        return this;
    }

    @Override
    public SolutionVersionImpl withProperties(SolutionVersionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public SolutionVersionImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

