/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionTemplateVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionTemplateVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkloadOrchestrationManagementClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.models.SolutionTemplateVersionListResult;
import com.azure.resourcemanager.workloadorchestration.models.BulkDeploySolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.BulkPublishSolutionParameter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SolutionTemplateVersionsClientImpl
implements SolutionTemplateVersionsClient {
    private final SolutionTemplateVersionsService service;
    private final WorkloadOrchestrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(SolutionTemplateVersionsClientImpl.class);

    SolutionTemplateVersionsClientImpl(WorkloadOrchestrationManagementClientImpl client) {
        this.service = (SolutionTemplateVersionsService)RestProxy.create(SolutionTemplateVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SolutionTemplateVersionInner>> getWithResponseAsync(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        if (solutionTemplateVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionTemplateVersionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, solutionTemplateVersionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SolutionTemplateVersionInner> getAsync(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName) {
        return this.getWithResponseAsync(resourceGroupName, solutionTemplateName, solutionTemplateVersionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SolutionTemplateVersionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SolutionTemplateVersionInner> getWithResponse(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        if (solutionTemplateVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateVersionName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, solutionTemplateVersionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SolutionTemplateVersionInner get(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName) {
        return (SolutionTemplateVersionInner)((Object)this.getWithResponse(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SolutionTemplateVersionInner>> listBySolutionTemplateSinglePageAsync(String resourceGroupName, String solutionTemplateName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySolutionTemplate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SolutionTemplateVersionListResult)res.getValue()).value(), ((SolutionTemplateVersionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SolutionTemplateVersionInner> listBySolutionTemplateAsync(String resourceGroupName, String solutionTemplateName) {
        return new PagedFlux(() -> this.listBySolutionTemplateSinglePageAsync(resourceGroupName, solutionTemplateName), nextLink -> this.listBySolutionTemplateNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SolutionTemplateVersionInner> listBySolutionTemplateSinglePage(String resourceGroupName, String solutionTemplateName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SolutionTemplateVersionListResult> res = this.service.listBySolutionTemplateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SolutionTemplateVersionListResult)res.getValue()).value(), ((SolutionTemplateVersionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SolutionTemplateVersionInner> listBySolutionTemplateSinglePage(String resourceGroupName, String solutionTemplateName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SolutionTemplateVersionListResult> res = this.service.listBySolutionTemplateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SolutionTemplateVersionListResult)res.getValue()).value(), ((SolutionTemplateVersionListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SolutionTemplateVersionInner> listBySolutionTemplate(String resourceGroupName, String solutionTemplateName) {
        return new PagedIterable(() -> this.listBySolutionTemplateSinglePage(resourceGroupName, solutionTemplateName), nextLink -> this.listBySolutionTemplateNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SolutionTemplateVersionInner> listBySolutionTemplate(String resourceGroupName, String solutionTemplateName, Context context) {
        return new PagedIterable(() -> this.listBySolutionTemplateSinglePage(resourceGroupName, solutionTemplateName, context), nextLink -> this.listBySolutionTemplateNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> bulkDeploySolutionWithResponseAsync(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        if (solutionTemplateVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionTemplateVersionName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return FluxUtil.withContext(context -> this.service.bulkDeploySolution(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, solutionTemplateVersionName, "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> bulkDeploySolutionWithResponse(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        if (solutionTemplateVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateVersionName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return this.service.bulkDeploySolutionSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, solutionTemplateVersionName, "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> bulkDeploySolutionWithResponse(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        if (solutionTemplateVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateVersionName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return this.service.bulkDeploySolutionSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, solutionTemplateVersionName, "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginBulkDeploySolutionAsync(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.bulkDeploySolutionWithResponseAsync(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginBulkDeploySolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body) {
        Response<BinaryData> response = this.bulkDeploySolutionWithResponse(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginBulkDeploySolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body, Context context) {
        Response<BinaryData> response = this.bulkDeploySolutionWithResponse(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> bulkDeploySolutionAsync(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body) {
        return this.beginBulkDeploySolutionAsync(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void bulkDeploySolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body) {
        this.beginBulkDeploySolution(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void bulkDeploySolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body, Context context) {
        this.beginBulkDeploySolution(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> bulkPublishSolutionWithResponseAsync(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        if (solutionTemplateVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionTemplateVersionName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return FluxUtil.withContext(context -> this.service.bulkPublishSolution(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, solutionTemplateVersionName, "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> bulkPublishSolutionWithResponse(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        if (solutionTemplateVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateVersionName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return this.service.bulkPublishSolutionSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, solutionTemplateVersionName, "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> bulkPublishSolutionWithResponse(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionTemplateName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateName is required and cannot be null."));
        }
        if (solutionTemplateVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionTemplateVersionName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return this.service.bulkPublishSolutionSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, solutionTemplateName, solutionTemplateVersionName, "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginBulkPublishSolutionAsync(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.bulkPublishSolutionWithResponseAsync(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginBulkPublishSolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body) {
        Response<BinaryData> response = this.bulkPublishSolutionWithResponse(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginBulkPublishSolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body, Context context) {
        Response<BinaryData> response = this.bulkPublishSolutionWithResponse(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> bulkPublishSolutionAsync(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body) {
        return this.beginBulkPublishSolutionAsync(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void bulkPublishSolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body) {
        this.beginBulkPublishSolution(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void bulkPublishSolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body, Context context) {
        this.beginBulkPublishSolution(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SolutionTemplateVersionInner>> listBySolutionTemplateNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySolutionTemplateNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SolutionTemplateVersionListResult)res.getValue()).value(), ((SolutionTemplateVersionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SolutionTemplateVersionInner> listBySolutionTemplateNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SolutionTemplateVersionListResult> res = this.service.listBySolutionTemplateNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SolutionTemplateVersionListResult)res.getValue()).value(), ((SolutionTemplateVersionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SolutionTemplateVersionInner> listBySolutionTemplateNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SolutionTemplateVersionListResult> res = this.service.listBySolutionTemplateNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SolutionTemplateVersionListResult)res.getValue()).value(), ((SolutionTemplateVersionListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="WorkloadOrchestrationManagementClientSolutionTemplateVersions")
    public static interface SolutionTemplateVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/solutionTemplates/{solutionTemplateName}/versions/{solutionTemplateVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SolutionTemplateVersionInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionTemplateName") String var5, @PathParam(value="solutionTemplateVersionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/solutionTemplates/{solutionTemplateName}/versions/{solutionTemplateVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SolutionTemplateVersionInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionTemplateName") String var5, @PathParam(value="solutionTemplateVersionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/solutionTemplates/{solutionTemplateName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SolutionTemplateVersionListResult>> listBySolutionTemplate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionTemplateName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/solutionTemplates/{solutionTemplateName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SolutionTemplateVersionListResult> listBySolutionTemplateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionTemplateName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/solutionTemplates/{solutionTemplateName}/versions/{solutionTemplateVersionName}/bulkDeploySolution")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> bulkDeploySolution(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionTemplateName") String var5, @PathParam(value="solutionTemplateVersionName") String var6, @HeaderParam(value="Content-Type") String var7, @BodyParam(value="application/json") BulkDeploySolutionParameter var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/solutionTemplates/{solutionTemplateName}/versions/{solutionTemplateVersionName}/bulkDeploySolution")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> bulkDeploySolutionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionTemplateName") String var5, @PathParam(value="solutionTemplateVersionName") String var6, @HeaderParam(value="Content-Type") String var7, @BodyParam(value="application/json") BulkDeploySolutionParameter var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/solutionTemplates/{solutionTemplateName}/versions/{solutionTemplateVersionName}/bulkPublishSolution")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> bulkPublishSolution(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionTemplateName") String var5, @PathParam(value="solutionTemplateVersionName") String var6, @HeaderParam(value="Content-Type") String var7, @BodyParam(value="application/json") BulkPublishSolutionParameter var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/solutionTemplates/{solutionTemplateName}/versions/{solutionTemplateVersionName}/bulkPublishSolution")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> bulkPublishSolutionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionTemplateName") String var5, @PathParam(value="solutionTemplateVersionName") String var6, @HeaderParam(value="Content-Type") String var7, @BodyParam(value="application/json") BulkPublishSolutionParameter var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SolutionTemplateVersionListResult>> listBySolutionTemplateNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SolutionTemplateVersionListResult> listBySolutionTemplateNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

