/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.Solution;
import com.azure.resourcemanager.workloadorchestration.models.SolutionProperties;

public final class SolutionImpl
implements Solution,
Solution.Definition,
Solution.Update {
    private SolutionInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String targetName;
    private String solutionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SolutionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SolutionInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SolutionImpl withExistingTarget(String resourceGroupName, String targetName) {
        this.resourceGroupName = resourceGroupName;
        this.targetName = targetName;
        return this;
    }

    @Override
    public Solution create() {
        this.innerObject = this.serviceManager.serviceClient().getSolutions().createOrUpdate(this.resourceGroupName, this.targetName, this.solutionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Solution create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSolutions().createOrUpdate(this.resourceGroupName, this.targetName, this.solutionName, this.innerModel(), context);
        return this;
    }

    SolutionImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new SolutionInner();
        this.serviceManager = serviceManager;
        this.solutionName = name;
    }

    @Override
    public SolutionImpl update() {
        return this;
    }

    @Override
    public Solution apply() {
        this.innerObject = this.serviceManager.serviceClient().getSolutions().update(this.resourceGroupName, this.targetName, this.solutionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Solution apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSolutions().update(this.resourceGroupName, this.targetName, this.solutionName, this.innerModel(), context);
        return this;
    }

    SolutionImpl(SolutionInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.targetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "targets");
        this.solutionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "solutions");
    }

    @Override
    public Solution refresh() {
        this.innerObject = (SolutionInner)((Object)this.serviceManager.serviceClient().getSolutions().getWithResponse(this.resourceGroupName, this.targetName, this.solutionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Solution refresh(Context context) {
        this.innerObject = (SolutionInner)((Object)this.serviceManager.serviceClient().getSolutions().getWithResponse(this.resourceGroupName, this.targetName, this.solutionName, context).getValue());
        return this;
    }

    @Override
    public SolutionImpl withProperties(SolutionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public SolutionImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

