/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.SiteReferencesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SiteReferenceInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SiteReferenceImpl;
import com.azure.resourcemanager.workloadorchestration.models.SiteReference;
import com.azure.resourcemanager.workloadorchestration.models.SiteReferences;

public final class SiteReferencesImpl
implements SiteReferences {
    private static final ClientLogger LOGGER = new ClientLogger(SiteReferencesImpl.class);
    private final SiteReferencesClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public SiteReferencesImpl(SiteReferencesClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SiteReference> getWithResponse(String resourceGroupName, String contextName, String siteReferenceName, Context context) {
        Response<SiteReferenceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, contextName, siteReferenceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SiteReferenceImpl((SiteReferenceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SiteReference get(String resourceGroupName, String contextName, String siteReferenceName) {
        SiteReferenceInner inner = this.serviceClient().get(resourceGroupName, contextName, siteReferenceName);
        if (inner != null) {
            return new SiteReferenceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String contextName, String siteReferenceName) {
        this.serviceClient().delete(resourceGroupName, contextName, siteReferenceName);
    }

    @Override
    public void delete(String resourceGroupName, String contextName, String siteReferenceName, Context context) {
        this.serviceClient().delete(resourceGroupName, contextName, siteReferenceName, context);
    }

    @Override
    public PagedIterable<SiteReference> listByContext(String resourceGroupName, String contextName) {
        PagedIterable<SiteReferenceInner> inner = this.serviceClient().listByContext(resourceGroupName, contextName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SiteReferenceImpl((SiteReferenceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SiteReference> listByContext(String resourceGroupName, String contextName, Context context) {
        PagedIterable<SiteReferenceInner> inner = this.serviceClient().listByContext(resourceGroupName, contextName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SiteReferenceImpl((SiteReferenceInner)((Object)inner1), this.manager()));
    }

    @Override
    public SiteReference getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String siteReferenceName = ResourceManagerUtils.getValueFromIdByName(id, "siteReferences");
        if (siteReferenceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'siteReferences'.", id)));
        }
        return (SiteReference)this.getWithResponse(resourceGroupName, contextName, siteReferenceName, Context.NONE).getValue();
    }

    @Override
    public Response<SiteReference> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String siteReferenceName = ResourceManagerUtils.getValueFromIdByName(id, "siteReferences");
        if (siteReferenceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'siteReferences'.", id)));
        }
        return this.getWithResponse(resourceGroupName, contextName, siteReferenceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String siteReferenceName = ResourceManagerUtils.getValueFromIdByName(id, "siteReferences");
        if (siteReferenceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'siteReferences'.", id)));
        }
        this.delete(resourceGroupName, contextName, siteReferenceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String siteReferenceName = ResourceManagerUtils.getValueFromIdByName(id, "siteReferences");
        if (siteReferenceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'siteReferences'.", id)));
        }
        this.delete(resourceGroupName, contextName, siteReferenceName, context);
    }

    private SiteReferencesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SiteReferenceImpl define(String name) {
        return new SiteReferenceImpl(name, this.manager());
    }
}

