/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SiteReferenceInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.SiteReference;
import com.azure.resourcemanager.workloadorchestration.models.SiteReferenceProperties;

public final class SiteReferenceImpl
implements SiteReference,
SiteReference.Definition,
SiteReference.Update {
    private SiteReferenceInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String contextName;
    private String siteReferenceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SiteReferenceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SiteReferenceInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SiteReferenceImpl withExistingContext(String resourceGroupName, String contextName) {
        this.resourceGroupName = resourceGroupName;
        this.contextName = contextName;
        return this;
    }

    @Override
    public SiteReference create() {
        this.innerObject = this.serviceManager.serviceClient().getSiteReferences().createOrUpdate(this.resourceGroupName, this.contextName, this.siteReferenceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SiteReference create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSiteReferences().createOrUpdate(this.resourceGroupName, this.contextName, this.siteReferenceName, this.innerModel(), context);
        return this;
    }

    SiteReferenceImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new SiteReferenceInner();
        this.serviceManager = serviceManager;
        this.siteReferenceName = name;
    }

    @Override
    public SiteReferenceImpl update() {
        return this;
    }

    @Override
    public SiteReference apply() {
        this.innerObject = this.serviceManager.serviceClient().getSiteReferences().update(this.resourceGroupName, this.contextName, this.siteReferenceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SiteReference apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSiteReferences().update(this.resourceGroupName, this.contextName, this.siteReferenceName, this.innerModel(), context);
        return this;
    }

    SiteReferenceImpl(SiteReferenceInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.contextName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contexts");
        this.siteReferenceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "siteReferences");
    }

    @Override
    public SiteReference refresh() {
        this.innerObject = (SiteReferenceInner)((Object)this.serviceManager.serviceClient().getSiteReferences().getWithResponse(this.resourceGroupName, this.contextName, this.siteReferenceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SiteReference refresh(Context context) {
        this.innerObject = (SiteReferenceInner)((Object)this.serviceManager.serviceClient().getSiteReferences().getWithResponse(this.resourceGroupName, this.contextName, this.siteReferenceName, context).getValue());
        return this;
    }

    @Override
    public SiteReferenceImpl withProperties(SiteReferenceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

