/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.SchemaVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemaVersionImpl;
import com.azure.resourcemanager.workloadorchestration.models.SchemaVersion;
import com.azure.resourcemanager.workloadorchestration.models.SchemaVersions;

public final class SchemaVersionsImpl
implements SchemaVersions {
    private static final ClientLogger LOGGER = new ClientLogger(SchemaVersionsImpl.class);
    private final SchemaVersionsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public SchemaVersionsImpl(SchemaVersionsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SchemaVersion> getWithResponse(String resourceGroupName, String schemaName, String schemaVersionName, Context context) {
        Response<SchemaVersionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, schemaName, schemaVersionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SchemaVersionImpl((SchemaVersionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SchemaVersion get(String resourceGroupName, String schemaName, String schemaVersionName) {
        SchemaVersionInner inner = this.serviceClient().get(resourceGroupName, schemaName, schemaVersionName);
        if (inner != null) {
            return new SchemaVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String schemaName, String schemaVersionName) {
        this.serviceClient().delete(resourceGroupName, schemaName, schemaVersionName);
    }

    @Override
    public void delete(String resourceGroupName, String schemaName, String schemaVersionName, Context context) {
        this.serviceClient().delete(resourceGroupName, schemaName, schemaVersionName, context);
    }

    @Override
    public PagedIterable<SchemaVersion> listBySchema(String resourceGroupName, String schemaName) {
        PagedIterable<SchemaVersionInner> inner = this.serviceClient().listBySchema(resourceGroupName, schemaName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaVersionImpl((SchemaVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SchemaVersion> listBySchema(String resourceGroupName, String schemaName, Context context) {
        PagedIterable<SchemaVersionInner> inner = this.serviceClient().listBySchema(resourceGroupName, schemaName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaVersionImpl((SchemaVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public SchemaVersion getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String schemaVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (schemaVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return (SchemaVersion)this.getWithResponse(resourceGroupName, schemaName, schemaVersionName, Context.NONE).getValue();
    }

    @Override
    public Response<SchemaVersion> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String schemaVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (schemaVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, schemaName, schemaVersionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String schemaVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (schemaVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.delete(resourceGroupName, schemaName, schemaVersionName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String schemaVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (schemaVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.delete(resourceGroupName, schemaName, schemaVersionName, context);
    }

    private SchemaVersionsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SchemaVersionImpl define(String name) {
        return new SchemaVersionImpl(name, this.manager());
    }
}

