/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.SchemaReferencesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaReferenceInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemaReferenceImpl;
import com.azure.resourcemanager.workloadorchestration.models.SchemaReference;
import com.azure.resourcemanager.workloadorchestration.models.SchemaReferences;

public final class SchemaReferencesImpl
implements SchemaReferences {
    private static final ClientLogger LOGGER = new ClientLogger(SchemaReferencesImpl.class);
    private final SchemaReferencesClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public SchemaReferencesImpl(SchemaReferencesClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SchemaReference> getWithResponse(String resourceUri, String schemaReferenceName, Context context) {
        Response<SchemaReferenceInner> inner = this.serviceClient().getWithResponse(resourceUri, schemaReferenceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SchemaReferenceImpl((SchemaReferenceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SchemaReference get(String resourceUri, String schemaReferenceName) {
        SchemaReferenceInner inner = this.serviceClient().get(resourceUri, schemaReferenceName);
        if (inner != null) {
            return new SchemaReferenceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SchemaReference> listByResourceGroup(String resourceUri) {
        PagedIterable<SchemaReferenceInner> inner = this.serviceClient().listByResourceGroup(resourceUri);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaReferenceImpl((SchemaReferenceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SchemaReference> listByResourceGroup(String resourceUri, Context context) {
        PagedIterable<SchemaReferenceInner> inner = this.serviceClient().listByResourceGroup(resourceUri, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaReferenceImpl((SchemaReferenceInner)((Object)inner1), this.manager()));
    }

    private SchemaReferencesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }
}

