/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaVersionWithUpdateTypeInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.RemoveVersionResponse;
import com.azure.resourcemanager.workloadorchestration.models.Schema;
import com.azure.resourcemanager.workloadorchestration.models.SchemaProperties;
import com.azure.resourcemanager.workloadorchestration.models.SchemaVersion;
import com.azure.resourcemanager.workloadorchestration.models.VersionParameter;
import java.util.Collections;
import java.util.Map;

public final class SchemaImpl
implements Schema,
Schema.Definition,
Schema.Update {
    private SchemaInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String schemaName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SchemaProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SchemaInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SchemaImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Schema create() {
        this.innerObject = this.serviceManager.serviceClient().getSchemas().createOrUpdate(this.resourceGroupName, this.schemaName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Schema create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSchemas().createOrUpdate(this.resourceGroupName, this.schemaName, this.innerModel(), context);
        return this;
    }

    SchemaImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new SchemaInner();
        this.serviceManager = serviceManager;
        this.schemaName = name;
    }

    @Override
    public SchemaImpl update() {
        return this;
    }

    @Override
    public Schema apply() {
        this.innerObject = (SchemaInner)((Object)this.serviceManager.serviceClient().getSchemas().updateWithResponse(this.resourceGroupName, this.schemaName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Schema apply(Context context) {
        this.innerObject = (SchemaInner)((Object)this.serviceManager.serviceClient().getSchemas().updateWithResponse(this.resourceGroupName, this.schemaName, this.innerModel(), context).getValue());
        return this;
    }

    SchemaImpl(SchemaInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.schemaName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schemas");
    }

    @Override
    public Schema refresh() {
        this.innerObject = (SchemaInner)((Object)this.serviceManager.serviceClient().getSchemas().getByResourceGroupWithResponse(this.resourceGroupName, this.schemaName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Schema refresh(Context context) {
        this.innerObject = (SchemaInner)((Object)this.serviceManager.serviceClient().getSchemas().getByResourceGroupWithResponse(this.resourceGroupName, this.schemaName, context).getValue());
        return this;
    }

    @Override
    public SchemaVersion createVersion(SchemaVersionWithUpdateTypeInner body) {
        return this.serviceManager.schemas().createVersion(this.resourceGroupName, this.schemaName, body);
    }

    @Override
    public SchemaVersion createVersion(SchemaVersionWithUpdateTypeInner body, Context context) {
        return this.serviceManager.schemas().createVersion(this.resourceGroupName, this.schemaName, body, context);
    }

    @Override
    public Response<RemoveVersionResponse> removeVersionWithResponse(VersionParameter body, Context context) {
        return this.serviceManager.schemas().removeVersionWithResponse(this.resourceGroupName, this.schemaName, body, context);
    }

    @Override
    public RemoveVersionResponse removeVersion(VersionParameter body) {
        return this.serviceManager.schemas().removeVersion(this.resourceGroupName, this.schemaName, body);
    }

    @Override
    public SchemaImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SchemaImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SchemaImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public SchemaImpl withProperties(SchemaProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

