/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.JobsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.JobInner;
import com.azure.resourcemanager.workloadorchestration.implementation.JobImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.Job;
import com.azure.resourcemanager.workloadorchestration.models.Jobs;

public final class JobsImpl
implements Jobs {
    private static final ClientLogger LOGGER = new ClientLogger(JobsImpl.class);
    private final JobsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public JobsImpl(JobsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Job> getWithResponse(String resourceUri, String jobName, Context context) {
        Response<JobInner> inner = this.serviceClient().getWithResponse(resourceUri, jobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobImpl((JobInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Job get(String resourceUri, String jobName) {
        JobInner inner = this.serviceClient().get(resourceUri, jobName);
        if (inner != null) {
            return new JobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Job> listByTarget(String resourceUri) {
        PagedIterable<JobInner> inner = this.serviceClient().listByTarget(resourceUri);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobImpl((JobInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Job> listByTarget(String resourceUri, Context context) {
        PagedIterable<JobInner> inner = this.serviceClient().listByTarget(resourceUri, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobImpl((JobInner)((Object)inner1), this.manager()));
    }

    private JobsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }
}

