/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.workloadorchestration.fluent.InstancesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.InstanceInner;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkloadOrchestrationManagementClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.models.InstanceListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class InstancesClientImpl
implements InstancesClient {
    private final InstancesService service;
    private final WorkloadOrchestrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(InstancesClientImpl.class);

    InstancesClientImpl(WorkloadOrchestrationManagementClientImpl client) {
        this.service = (InstancesService)RestProxy.create(InstancesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<InstanceInner>> getWithResponseAsync(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InstanceInner> getAsync(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        return this.getWithResponseAsync(resourceGroupName, targetName, solutionName, instanceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((InstanceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InstanceInner> getWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InstanceInner get(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        return (InstanceInner)((Object)this.getWithResponse(resourceGroupName, targetName, solutionName, instanceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, "application/json", "application/json", resource, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<InstanceInner>, InstanceInner> beginCreateOrUpdateAsync(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, targetName, solutionName, instanceName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)InstanceInner.class), (Type)((Object)InstanceInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InstanceInner>, InstanceInner> beginCreateOrUpdate(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, targetName, solutionName, instanceName, resource);
        return this.client.getLroResult(response, (Type)((Object)InstanceInner.class), (Type)((Object)InstanceInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InstanceInner>, InstanceInner> beginCreateOrUpdate(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, targetName, solutionName, instanceName, resource, context);
        return this.client.getLroResult(response, (Type)((Object)InstanceInner.class), (Type)((Object)InstanceInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InstanceInner> createOrUpdateAsync(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, targetName, solutionName, instanceName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InstanceInner createOrUpdate(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource) {
        return (InstanceInner)((Object)this.beginCreateOrUpdate(resourceGroupName, targetName, solutionName, instanceName, resource).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InstanceInner createOrUpdate(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner resource, Context context) {
        return (InstanceInner)((Object)this.beginCreateOrUpdate(resourceGroupName, targetName, solutionName, instanceName, resource, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, "application/json", "application/json", properties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<InstanceInner>, InstanceInner> beginUpdateAsync(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, targetName, solutionName, instanceName, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)InstanceInner.class), (Type)((Object)InstanceInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InstanceInner>, InstanceInner> beginUpdate(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, targetName, solutionName, instanceName, properties);
        return this.client.getLroResult(response, (Type)((Object)InstanceInner.class), (Type)((Object)InstanceInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InstanceInner>, InstanceInner> beginUpdate(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, targetName, solutionName, instanceName, properties, context);
        return this.client.getLroResult(response, (Type)((Object)InstanceInner.class), (Type)((Object)InstanceInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InstanceInner> updateAsync(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties) {
        return this.beginUpdateAsync(resourceGroupName, targetName, solutionName, instanceName, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InstanceInner update(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties) {
        return (InstanceInner)((Object)this.beginUpdate(resourceGroupName, targetName, solutionName, instanceName, properties).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InstanceInner update(String resourceGroupName, String targetName, String solutionName, String instanceName, InstanceInner properties, Context context) {
        return (InstanceInner)((Object)this.beginUpdate(resourceGroupName, targetName, solutionName, instanceName, properties, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        if (instanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter instanceName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, instanceName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, targetName, solutionName, instanceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, targetName, solutionName, instanceName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String targetName, String solutionName, String instanceName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, targetName, solutionName, instanceName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        return this.beginDeleteAsync(resourceGroupName, targetName, solutionName, instanceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        this.beginDelete(resourceGroupName, targetName, solutionName, instanceName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String targetName, String solutionName, String instanceName, Context context) {
        this.beginDelete(resourceGroupName, targetName, solutionName, instanceName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<InstanceInner>> listBySolutionSinglePageAsync(String resourceGroupName, String targetName, String solutionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySolution(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InstanceListResult)res.getValue()).value(), ((InstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<InstanceInner> listBySolutionAsync(String resourceGroupName, String targetName, String solutionName) {
        return new PagedFlux(() -> this.listBySolutionSinglePageAsync(resourceGroupName, targetName, solutionName), nextLink -> this.listBySolutionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<InstanceInner> listBySolutionSinglePage(String resourceGroupName, String targetName, String solutionName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<InstanceListResult> res = this.service.listBySolutionSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InstanceListResult)res.getValue()).value(), ((InstanceListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<InstanceInner> listBySolutionSinglePage(String resourceGroupName, String targetName, String solutionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (solutionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<InstanceListResult> res = this.service.listBySolutionSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, targetName, solutionName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InstanceListResult)res.getValue()).value(), ((InstanceListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<InstanceInner> listBySolution(String resourceGroupName, String targetName, String solutionName) {
        return new PagedIterable(() -> this.listBySolutionSinglePage(resourceGroupName, targetName, solutionName), nextLink -> this.listBySolutionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<InstanceInner> listBySolution(String resourceGroupName, String targetName, String solutionName, Context context) {
        return new PagedIterable(() -> this.listBySolutionSinglePage(resourceGroupName, targetName, solutionName, context), nextLink -> this.listBySolutionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<InstanceInner>> listBySolutionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySolutionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InstanceListResult)res.getValue()).value(), ((InstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<InstanceInner> listBySolutionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<InstanceListResult> res = this.service.listBySolutionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InstanceListResult)res.getValue()).value(), ((InstanceListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<InstanceInner> listBySolutionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<InstanceListResult> res = this.service.listBySolutionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InstanceListResult)res.getValue()).value(), ((InstanceListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="WorkloadOrchestrationManagementClientInstances")
    public static interface InstancesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances/{instanceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InstanceInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @PathParam(value="instanceName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances/{instanceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<InstanceInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @PathParam(value="instanceName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances/{instanceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @PathParam(value="instanceName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") InstanceInner var10, Context var11);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances/{instanceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @PathParam(value="instanceName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") InstanceInner var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances/{instanceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @PathParam(value="instanceName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") InstanceInner var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances/{instanceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @PathParam(value="instanceName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") InstanceInner var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances/{instanceName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @PathParam(value="instanceName") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances/{instanceName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @PathParam(value="instanceName") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InstanceListResult>> listBySolution(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/targets/{targetName}/solutions/{solutionName}/instances")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<InstanceListResult> listBySolutionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetName") String var5, @PathParam(value="solutionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InstanceListResult>> listBySolutionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<InstanceListResult> listBySolutionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

