/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.InstanceHistoriesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.InstanceHistoryInner;
import com.azure.resourcemanager.workloadorchestration.implementation.InstanceHistoryImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.InstanceHistories;
import com.azure.resourcemanager.workloadorchestration.models.InstanceHistory;

public final class InstanceHistoriesImpl
implements InstanceHistories {
    private static final ClientLogger LOGGER = new ClientLogger(InstanceHistoriesImpl.class);
    private final InstanceHistoriesClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public InstanceHistoriesImpl(InstanceHistoriesClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<InstanceHistory> getWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName, String instanceHistoryName, Context context) {
        Response<InstanceHistoryInner> inner = this.serviceClient().getWithResponse(resourceGroupName, targetName, solutionName, instanceName, instanceHistoryName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new InstanceHistoryImpl((InstanceHistoryInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public InstanceHistory get(String resourceGroupName, String targetName, String solutionName, String instanceName, String instanceHistoryName) {
        InstanceHistoryInner inner = this.serviceClient().get(resourceGroupName, targetName, solutionName, instanceName, instanceHistoryName);
        if (inner != null) {
            return new InstanceHistoryImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<InstanceHistory> listByInstance(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        PagedIterable<InstanceHistoryInner> inner = this.serviceClient().listByInstance(resourceGroupName, targetName, solutionName, instanceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InstanceHistoryImpl((InstanceHistoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<InstanceHistory> listByInstance(String resourceGroupName, String targetName, String solutionName, String instanceName, Context context) {
        PagedIterable<InstanceHistoryInner> inner = this.serviceClient().listByInstance(resourceGroupName, targetName, solutionName, instanceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InstanceHistoryImpl((InstanceHistoryInner)((Object)inner1), this.manager()));
    }

    private InstanceHistoriesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }
}

