/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.ExecutionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ExecutionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ExecutionImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.Execution;
import com.azure.resourcemanager.workloadorchestration.models.Executions;

public final class ExecutionsImpl
implements Executions {
    private static final ClientLogger LOGGER = new ClientLogger(ExecutionsImpl.class);
    private final ExecutionsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public ExecutionsImpl(ExecutionsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Execution> getWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, Context context) {
        Response<ExecutionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExecutionImpl((ExecutionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Execution get(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        ExecutionInner inner = this.serviceClient().get(resourceGroupName, contextName, workflowName, versionName, executionName);
        if (inner != null) {
            return new ExecutionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        this.serviceClient().delete(resourceGroupName, contextName, workflowName, versionName, executionName);
    }

    @Override
    public void delete(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, Context context) {
        this.serviceClient().delete(resourceGroupName, contextName, workflowName, versionName, executionName, context);
    }

    @Override
    public PagedIterable<Execution> listByWorkflowVersion(String resourceGroupName, String contextName, String workflowName, String versionName) {
        PagedIterable<ExecutionInner> inner = this.serviceClient().listByWorkflowVersion(resourceGroupName, contextName, workflowName, versionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExecutionImpl((ExecutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Execution> listByWorkflowVersion(String resourceGroupName, String contextName, String workflowName, String versionName, Context context) {
        PagedIterable<ExecutionInner> inner = this.serviceClient().listByWorkflowVersion(resourceGroupName, contextName, workflowName, versionName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExecutionImpl((ExecutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Execution getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        String executionName = ResourceManagerUtils.getValueFromIdByName(id, "executions");
        if (executionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'executions'.", id)));
        }
        return (Execution)this.getWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, Context.NONE).getValue();
    }

    @Override
    public Response<Execution> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        String executionName = ResourceManagerUtils.getValueFromIdByName(id, "executions");
        if (executionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'executions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        String executionName = ResourceManagerUtils.getValueFromIdByName(id, "executions");
        if (executionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'executions'.", id)));
        }
        this.delete(resourceGroupName, contextName, workflowName, versionName, executionName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        String workflowName = ResourceManagerUtils.getValueFromIdByName(id, "workflows");
        if (workflowName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workflows'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        String executionName = ResourceManagerUtils.getValueFromIdByName(id, "executions");
        if (executionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'executions'.", id)));
        }
        this.delete(resourceGroupName, contextName, workflowName, versionName, executionName, context);
    }

    private ExecutionsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ExecutionImpl define(String name) {
        return new ExecutionImpl(name, this.manager());
    }
}

