/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ExecutionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.Execution;
import com.azure.resourcemanager.workloadorchestration.models.ExecutionProperties;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;

public final class ExecutionImpl
implements Execution,
Execution.Definition,
Execution.Update {
    private ExecutionInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String contextName;
    private String workflowName;
    private String versionName;
    private String executionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ExecutionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ExecutionInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ExecutionImpl withExistingVersion(String resourceGroupName, String contextName, String workflowName, String versionName) {
        this.resourceGroupName = resourceGroupName;
        this.contextName = contextName;
        this.workflowName = workflowName;
        this.versionName = versionName;
        return this;
    }

    @Override
    public Execution create() {
        this.innerObject = this.serviceManager.serviceClient().getExecutions().createOrUpdate(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.executionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Execution create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getExecutions().createOrUpdate(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.executionName, this.innerModel(), context);
        return this;
    }

    ExecutionImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new ExecutionInner();
        this.serviceManager = serviceManager;
        this.executionName = name;
    }

    @Override
    public ExecutionImpl update() {
        return this;
    }

    @Override
    public Execution apply() {
        this.innerObject = this.serviceManager.serviceClient().getExecutions().update(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.executionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Execution apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getExecutions().update(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.executionName, this.innerModel(), context);
        return this;
    }

    ExecutionImpl(ExecutionInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.contextName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contexts");
        this.workflowName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workflows");
        this.versionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "versions");
        this.executionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "executions");
    }

    @Override
    public Execution refresh() {
        this.innerObject = (ExecutionInner)((Object)this.serviceManager.serviceClient().getExecutions().getWithResponse(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.executionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Execution refresh(Context context) {
        this.innerObject = (ExecutionInner)((Object)this.serviceManager.serviceClient().getExecutions().getWithResponse(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.executionName, context).getValue());
        return this;
    }

    @Override
    public ExecutionImpl withProperties(ExecutionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ExecutionImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

