/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.workloadorchestration.fluent.DynamicSchemaVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.DynamicSchemaVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkloadOrchestrationManagementClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.models.DynamicSchemaVersionListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DynamicSchemaVersionsClientImpl
implements DynamicSchemaVersionsClient {
    private final DynamicSchemaVersionsService service;
    private final WorkloadOrchestrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DynamicSchemaVersionsClientImpl.class);

    DynamicSchemaVersionsClientImpl(WorkloadOrchestrationManagementClientImpl client) {
        this.service = (DynamicSchemaVersionsService)RestProxy.create(DynamicSchemaVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DynamicSchemaVersionInner>> getWithResponseAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DynamicSchemaVersionInner> getAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        return this.getWithResponseAsync(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DynamicSchemaVersionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DynamicSchemaVersionInner> getWithResponse(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DynamicSchemaVersionInner get(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        return (DynamicSchemaVersionInner)((Object)this.getWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, "application/json", "application/json", resource, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DynamicSchemaVersionInner>, DynamicSchemaVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DynamicSchemaVersionInner.class), (Type)((Object)DynamicSchemaVersionInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DynamicSchemaVersionInner>, DynamicSchemaVersionInner> beginCreateOrUpdate(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, resource);
        return this.client.getLroResult(response, (Type)((Object)DynamicSchemaVersionInner.class), (Type)((Object)DynamicSchemaVersionInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DynamicSchemaVersionInner>, DynamicSchemaVersionInner> beginCreateOrUpdate(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, resource, context);
        return this.client.getLroResult(response, (Type)((Object)DynamicSchemaVersionInner.class), (Type)((Object)DynamicSchemaVersionInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DynamicSchemaVersionInner> createOrUpdateAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DynamicSchemaVersionInner createOrUpdate(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource) {
        return (DynamicSchemaVersionInner)((Object)this.beginCreateOrUpdate(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, resource).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DynamicSchemaVersionInner createOrUpdate(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner resource, Context context) {
        return (DynamicSchemaVersionInner)((Object)this.beginCreateOrUpdate(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, resource, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DynamicSchemaVersionInner>> updateWithResponseAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DynamicSchemaVersionInner> updateAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner properties) {
        return this.updateWithResponseAsync(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, properties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DynamicSchemaVersionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DynamicSchemaVersionInner> updateWithResponse(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, "application/json", "application/json", properties, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DynamicSchemaVersionInner update(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, DynamicSchemaVersionInner properties) {
        return (DynamicSchemaVersionInner)((Object)this.updateWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, properties, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaVersionName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        return this.beginDeleteAsync(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        this.beginDelete(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, Context context) {
        this.beginDelete(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DynamicSchemaVersionInner>> listByDynamicSchemaSinglePageAsync(String resourceGroupName, String schemaName, String dynamicSchemaName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDynamicSchema(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DynamicSchemaVersionListResult)res.getValue()).value(), ((DynamicSchemaVersionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DynamicSchemaVersionInner> listByDynamicSchemaAsync(String resourceGroupName, String schemaName, String dynamicSchemaName) {
        return new PagedFlux(() -> this.listByDynamicSchemaSinglePageAsync(resourceGroupName, schemaName, dynamicSchemaName), nextLink -> this.listByDynamicSchemaNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DynamicSchemaVersionInner> listByDynamicSchemaSinglePage(String resourceGroupName, String schemaName, String dynamicSchemaName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DynamicSchemaVersionListResult> res = this.service.listByDynamicSchemaSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DynamicSchemaVersionListResult)res.getValue()).value(), ((DynamicSchemaVersionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DynamicSchemaVersionInner> listByDynamicSchemaSinglePage(String resourceGroupName, String schemaName, String dynamicSchemaName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (schemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (dynamicSchemaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dynamicSchemaName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DynamicSchemaVersionListResult> res = this.service.listByDynamicSchemaSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schemaName, dynamicSchemaName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DynamicSchemaVersionListResult)res.getValue()).value(), ((DynamicSchemaVersionListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DynamicSchemaVersionInner> listByDynamicSchema(String resourceGroupName, String schemaName, String dynamicSchemaName) {
        return new PagedIterable(() -> this.listByDynamicSchemaSinglePage(resourceGroupName, schemaName, dynamicSchemaName), nextLink -> this.listByDynamicSchemaNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DynamicSchemaVersionInner> listByDynamicSchema(String resourceGroupName, String schemaName, String dynamicSchemaName, Context context) {
        return new PagedIterable(() -> this.listByDynamicSchemaSinglePage(resourceGroupName, schemaName, dynamicSchemaName, context), nextLink -> this.listByDynamicSchemaNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DynamicSchemaVersionInner>> listByDynamicSchemaNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDynamicSchemaNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DynamicSchemaVersionListResult)res.getValue()).value(), ((DynamicSchemaVersionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DynamicSchemaVersionInner> listByDynamicSchemaNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DynamicSchemaVersionListResult> res = this.service.listByDynamicSchemaNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DynamicSchemaVersionListResult)res.getValue()).value(), ((DynamicSchemaVersionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DynamicSchemaVersionInner> listByDynamicSchemaNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DynamicSchemaVersionListResult> res = this.service.listByDynamicSchemaNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DynamicSchemaVersionListResult)res.getValue()).value(), ((DynamicSchemaVersionListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="WorkloadOrchestrationManagementClientDynamicSchemaVersions")
    public static interface DynamicSchemaVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions/{dynamicSchemaVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DynamicSchemaVersionInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @PathParam(value="dynamicSchemaVersionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions/{dynamicSchemaVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DynamicSchemaVersionInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @PathParam(value="dynamicSchemaVersionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions/{dynamicSchemaVersionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @PathParam(value="dynamicSchemaVersionName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DynamicSchemaVersionInner var10, Context var11);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions/{dynamicSchemaVersionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @PathParam(value="dynamicSchemaVersionName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DynamicSchemaVersionInner var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions/{dynamicSchemaVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DynamicSchemaVersionInner>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @PathParam(value="dynamicSchemaVersionName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DynamicSchemaVersionInner var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions/{dynamicSchemaVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DynamicSchemaVersionInner> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @PathParam(value="dynamicSchemaVersionName") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DynamicSchemaVersionInner var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions/{dynamicSchemaVersionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @PathParam(value="dynamicSchemaVersionName") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions/{dynamicSchemaVersionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @PathParam(value="dynamicSchemaVersionName") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DynamicSchemaVersionListResult>> listByDynamicSchema(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/schemas/{schemaName}/dynamicSchemas/{dynamicSchemaName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DynamicSchemaVersionListResult> listByDynamicSchemaSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="dynamicSchemaName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DynamicSchemaVersionListResult>> listByDynamicSchemaNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DynamicSchemaVersionListResult> listByDynamicSchemaNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

