/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.DynamicSchemaVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchemaVersion;
import com.azure.resourcemanager.workloadorchestration.models.SchemaVersionProperties;

public final class DynamicSchemaVersionImpl
implements DynamicSchemaVersion,
DynamicSchemaVersion.Definition,
DynamicSchemaVersion.Update {
    private DynamicSchemaVersionInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String schemaName;
    private String dynamicSchemaName;
    private String dynamicSchemaVersionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SchemaVersionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DynamicSchemaVersionInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DynamicSchemaVersionImpl withExistingDynamicSchema(String resourceGroupName, String schemaName, String dynamicSchemaName) {
        this.resourceGroupName = resourceGroupName;
        this.schemaName = schemaName;
        this.dynamicSchemaName = dynamicSchemaName;
        return this;
    }

    @Override
    public DynamicSchemaVersion create() {
        this.innerObject = this.serviceManager.serviceClient().getDynamicSchemaVersions().createOrUpdate(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.dynamicSchemaVersionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DynamicSchemaVersion create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDynamicSchemaVersions().createOrUpdate(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.dynamicSchemaVersionName, this.innerModel(), context);
        return this;
    }

    DynamicSchemaVersionImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new DynamicSchemaVersionInner();
        this.serviceManager = serviceManager;
        this.dynamicSchemaVersionName = name;
    }

    @Override
    public DynamicSchemaVersionImpl update() {
        return this;
    }

    @Override
    public DynamicSchemaVersion apply() {
        this.innerObject = (DynamicSchemaVersionInner)((Object)this.serviceManager.serviceClient().getDynamicSchemaVersions().updateWithResponse(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.dynamicSchemaVersionName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DynamicSchemaVersion apply(Context context) {
        this.innerObject = (DynamicSchemaVersionInner)((Object)this.serviceManager.serviceClient().getDynamicSchemaVersions().updateWithResponse(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.dynamicSchemaVersionName, this.innerModel(), context).getValue());
        return this;
    }

    DynamicSchemaVersionImpl(DynamicSchemaVersionInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.schemaName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schemas");
        this.dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dynamicSchemas");
        this.dynamicSchemaVersionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "versions");
    }

    @Override
    public DynamicSchemaVersion refresh() {
        this.innerObject = (DynamicSchemaVersionInner)((Object)this.serviceManager.serviceClient().getDynamicSchemaVersions().getWithResponse(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.dynamicSchemaVersionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DynamicSchemaVersion refresh(Context context) {
        this.innerObject = (DynamicSchemaVersionInner)((Object)this.serviceManager.serviceClient().getDynamicSchemaVersions().getWithResponse(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.dynamicSchemaVersionName, context).getValue());
        return this;
    }

    @Override
    public DynamicSchemaVersionImpl withProperties(SchemaVersionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

