/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.DiagnosticInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.Diagnostic;
import com.azure.resourcemanager.workloadorchestration.models.DiagnosticProperties;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import java.util.Collections;
import java.util.Map;

public final class DiagnosticImpl
implements Diagnostic,
Diagnostic.Definition,
Diagnostic.Update {
    private DiagnosticInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String diagnosticName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public DiagnosticProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DiagnosticInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DiagnosticImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Diagnostic create() {
        this.innerObject = this.serviceManager.serviceClient().getDiagnostics().createOrUpdate(this.resourceGroupName, this.diagnosticName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Diagnostic create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDiagnostics().createOrUpdate(this.resourceGroupName, this.diagnosticName, this.innerModel(), context);
        return this;
    }

    DiagnosticImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new DiagnosticInner();
        this.serviceManager = serviceManager;
        this.diagnosticName = name;
    }

    @Override
    public DiagnosticImpl update() {
        return this;
    }

    @Override
    public Diagnostic apply() {
        this.innerObject = this.serviceManager.serviceClient().getDiagnostics().update(this.resourceGroupName, this.diagnosticName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Diagnostic apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDiagnostics().update(this.resourceGroupName, this.diagnosticName, this.innerModel(), context);
        return this;
    }

    DiagnosticImpl(DiagnosticInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.diagnosticName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "diagnostics");
    }

    @Override
    public Diagnostic refresh() {
        this.innerObject = (DiagnosticInner)((Object)this.serviceManager.serviceClient().getDiagnostics().getByResourceGroupWithResponse(this.resourceGroupName, this.diagnosticName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Diagnostic refresh(Context context) {
        this.innerObject = (DiagnosticInner)((Object)this.serviceManager.serviceClient().getDiagnostics().getByResourceGroupWithResponse(this.resourceGroupName, this.diagnosticName, context).getValue());
        return this;
    }

    @Override
    public DiagnosticImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DiagnosticImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DiagnosticImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public DiagnosticImpl withProperties(DiagnosticProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public DiagnosticImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

