/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.ContextsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ContextInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ContextModelImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ContextModel;
import com.azure.resourcemanager.workloadorchestration.models.Contexts;

public final class ContextsImpl
implements Contexts {
    private static final ClientLogger LOGGER = new ClientLogger(ContextsImpl.class);
    private final ContextsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public ContextsImpl(ContextsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ContextModel> getByResourceGroupWithResponse(String resourceGroupName, String contextName, Context context) {
        Response<ContextInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, contextName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ContextModelImpl((ContextInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ContextModel getByResourceGroup(String resourceGroupName, String contextName) {
        ContextInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, contextName);
        if (inner != null) {
            return new ContextModelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ContextModel> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ContextInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContextModelImpl((ContextInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContextModel> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ContextInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContextModelImpl((ContextInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContextModel> list() {
        PagedIterable<ContextInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContextModelImpl((ContextInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContextModel> list(Context context) {
        PagedIterable<ContextInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContextModelImpl((ContextInner)((Object)inner1), this.manager()));
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String contextName) {
        this.serviceClient().delete(resourceGroupName, contextName);
    }

    @Override
    public void delete(String resourceGroupName, String contextName, Context context) {
        this.serviceClient().delete(resourceGroupName, contextName, context);
    }

    @Override
    public ContextModel getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        return (ContextModel)this.getByResourceGroupWithResponse(resourceGroupName, contextName, Context.NONE).getValue();
    }

    @Override
    public Response<ContextModel> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, contextName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        this.delete(resourceGroupName, contextName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String contextName = ResourceManagerUtils.getValueFromIdByName(id, "contexts");
        if (contextName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contexts'.", id)));
        }
        this.delete(resourceGroupName, contextName, context);
    }

    private ContextsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ContextModelImpl define(String name) {
        return new ContextModelImpl(name, this.manager());
    }
}

