/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.ConfigTemplatesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ConfigTemplateInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ConfigTemplateVersionInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ConfigTemplateVersionWithUpdateTypeInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.RemoveVersionResponseInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ConfigTemplateImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ConfigTemplateVersionImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.RemoveVersionResponseImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplate;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplateVersion;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplates;
import com.azure.resourcemanager.workloadorchestration.models.RemoveVersionResponse;
import com.azure.resourcemanager.workloadorchestration.models.VersionParameter;

public final class ConfigTemplatesImpl
implements ConfigTemplates {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigTemplatesImpl.class);
    private final ConfigTemplatesClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public ConfigTemplatesImpl(ConfigTemplatesClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ConfigTemplate> getByResourceGroupWithResponse(String resourceGroupName, String configTemplateName, Context context) {
        Response<ConfigTemplateInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, configTemplateName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigTemplateImpl((ConfigTemplateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigTemplate getByResourceGroup(String resourceGroupName, String configTemplateName) {
        ConfigTemplateInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, configTemplateName);
        if (inner != null) {
            return new ConfigTemplateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ConfigTemplateVersion createVersion(String resourceGroupName, String configTemplateName, ConfigTemplateVersionWithUpdateTypeInner body) {
        ConfigTemplateVersionInner inner = this.serviceClient().createVersion(resourceGroupName, configTemplateName, body);
        if (inner != null) {
            return new ConfigTemplateVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ConfigTemplateVersion createVersion(String resourceGroupName, String configTemplateName, ConfigTemplateVersionWithUpdateTypeInner body, Context context) {
        ConfigTemplateVersionInner inner = this.serviceClient().createVersion(resourceGroupName, configTemplateName, body, context);
        if (inner != null) {
            return new ConfigTemplateVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RemoveVersionResponse> removeVersionWithResponse(String resourceGroupName, String configTemplateName, VersionParameter body, Context context) {
        Response<RemoveVersionResponseInner> inner = this.serviceClient().removeVersionWithResponse(resourceGroupName, configTemplateName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemoveVersionResponseImpl((RemoveVersionResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RemoveVersionResponse removeVersion(String resourceGroupName, String configTemplateName, VersionParameter body) {
        RemoveVersionResponseInner inner = this.serviceClient().removeVersion(resourceGroupName, configTemplateName, body);
        if (inner != null) {
            return new RemoveVersionResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String configTemplateName) {
        this.serviceClient().delete(resourceGroupName, configTemplateName);
    }

    @Override
    public void delete(String resourceGroupName, String configTemplateName, Context context) {
        this.serviceClient().delete(resourceGroupName, configTemplateName, context);
    }

    @Override
    public PagedIterable<ConfigTemplate> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ConfigTemplateInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigTemplateImpl((ConfigTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigTemplate> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ConfigTemplateInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigTemplateImpl((ConfigTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigTemplate> list() {
        PagedIterable<ConfigTemplateInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigTemplateImpl((ConfigTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigTemplate> list(Context context) {
        PagedIterable<ConfigTemplateInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigTemplateImpl((ConfigTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public ConfigTemplate getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configTemplateName = ResourceManagerUtils.getValueFromIdByName(id, "configTemplates");
        if (configTemplateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configTemplates'.", id)));
        }
        return (ConfigTemplate)this.getByResourceGroupWithResponse(resourceGroupName, configTemplateName, Context.NONE).getValue();
    }

    @Override
    public Response<ConfigTemplate> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configTemplateName = ResourceManagerUtils.getValueFromIdByName(id, "configTemplates");
        if (configTemplateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configTemplates'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, configTemplateName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configTemplateName = ResourceManagerUtils.getValueFromIdByName(id, "configTemplates");
        if (configTemplateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configTemplates'.", id)));
        }
        this.delete(resourceGroupName, configTemplateName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configTemplateName = ResourceManagerUtils.getValueFromIdByName(id, "configTemplates");
        if (configTemplateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configTemplates'.", id)));
        }
        this.delete(resourceGroupName, configTemplateName, context);
    }

    private ConfigTemplatesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigTemplateImpl define(String name) {
        return new ConfigTemplateImpl(name, this.manager());
    }
}

