/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ConfigTemplateInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ConfigTemplateVersionWithUpdateTypeInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplate;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplateProperties;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplateVersion;
import com.azure.resourcemanager.workloadorchestration.models.RemoveVersionResponse;
import com.azure.resourcemanager.workloadorchestration.models.VersionParameter;
import java.util.Collections;
import java.util.Map;

public final class ConfigTemplateImpl
implements ConfigTemplate,
ConfigTemplate.Definition,
ConfigTemplate.Update {
    private ConfigTemplateInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String configTemplateName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ConfigTemplateProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConfigTemplateInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigTemplateImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ConfigTemplate create() {
        this.innerObject = this.serviceManager.serviceClient().getConfigTemplates().createOrUpdate(this.resourceGroupName, this.configTemplateName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ConfigTemplate create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConfigTemplates().createOrUpdate(this.resourceGroupName, this.configTemplateName, this.innerModel(), context);
        return this;
    }

    ConfigTemplateImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new ConfigTemplateInner();
        this.serviceManager = serviceManager;
        this.configTemplateName = name;
    }

    @Override
    public ConfigTemplateImpl update() {
        return this;
    }

    @Override
    public ConfigTemplate apply() {
        this.innerObject = (ConfigTemplateInner)((Object)this.serviceManager.serviceClient().getConfigTemplates().updateWithResponse(this.resourceGroupName, this.configTemplateName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigTemplate apply(Context context) {
        this.innerObject = (ConfigTemplateInner)((Object)this.serviceManager.serviceClient().getConfigTemplates().updateWithResponse(this.resourceGroupName, this.configTemplateName, this.innerModel(), context).getValue());
        return this;
    }

    ConfigTemplateImpl(ConfigTemplateInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.configTemplateName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configTemplates");
    }

    @Override
    public ConfigTemplate refresh() {
        this.innerObject = (ConfigTemplateInner)((Object)this.serviceManager.serviceClient().getConfigTemplates().getByResourceGroupWithResponse(this.resourceGroupName, this.configTemplateName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigTemplate refresh(Context context) {
        this.innerObject = (ConfigTemplateInner)((Object)this.serviceManager.serviceClient().getConfigTemplates().getByResourceGroupWithResponse(this.resourceGroupName, this.configTemplateName, context).getValue());
        return this;
    }

    @Override
    public ConfigTemplateVersion createVersion(ConfigTemplateVersionWithUpdateTypeInner body) {
        return this.serviceManager.configTemplates().createVersion(this.resourceGroupName, this.configTemplateName, body);
    }

    @Override
    public ConfigTemplateVersion createVersion(ConfigTemplateVersionWithUpdateTypeInner body, Context context) {
        return this.serviceManager.configTemplates().createVersion(this.resourceGroupName, this.configTemplateName, body, context);
    }

    @Override
    public Response<RemoveVersionResponse> removeVersionWithResponse(VersionParameter body, Context context) {
        return this.serviceManager.configTemplates().removeVersionWithResponse(this.resourceGroupName, this.configTemplateName, body, context);
    }

    @Override
    public RemoveVersionResponse removeVersion(VersionParameter body) {
        return this.serviceManager.configTemplates().removeVersion(this.resourceGroupName, this.configTemplateName, body);
    }

    @Override
    public ConfigTemplateImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ConfigTemplateImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ConfigTemplateImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public ConfigTemplateImpl withProperties(ConfigTemplateProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

