/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ContextProperties;
import java.io.IOException;
import java.util.Map;

public final class ContextInner
extends Resource {
    private ContextProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ContextProperties properties() {
        return this.properties;
    }

    public ContextInner withProperties(ContextProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ContextInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ContextInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ContextInner fromJson(JsonReader jsonReader) throws IOException {
        return (ContextInner)((Object)jsonReader.readObject(reader -> {
            ContextInner deserializedContextInner = new ContextInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContextInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContextInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContextInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedContextInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedContextInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedContextInner.properties = ContextProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedContextInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContextInner;
        }));
    }
}

