/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.azure.resourcemanager.trafficmanager.fluent.TrafficManagerManagementClient;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerManagementClientBuilder;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerProfilesImpl;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfiles;

public final class TrafficManager
extends Manager<TrafficManagerManagementClient> {
    private TrafficManagerProfiles profiles;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static TrafficManager authenticate(TokenCredential credential, AzureProfile profile) {
        return TrafficManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static TrafficManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new TrafficManager(httpPipeline, profile);
    }

    private TrafficManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new TrafficManagerManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public TrafficManagerProfiles profiles() {
        if (this.profiles == null) {
            this.profiles = new TrafficManagerProfilesImpl(this);
        }
        return this.profiles;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public TrafficManager authenticate(TokenCredential credential, AzureProfile profile) {
            return TrafficManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public TrafficManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

