/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.test;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.models.AzureCloud;
import com.azure.core.test.TestMode;
import com.azure.core.test.TestProxyTestBase;
import com.azure.core.test.models.CustomMatcher;
import com.azure.core.test.models.TestProxySanitizer;
import com.azure.core.test.models.TestProxySanitizerType;
import com.azure.core.test.utils.MockTokenCredential;
import com.azure.core.test.utils.ResourceNamer;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.resourcemanager.test.model.AzureUser;
import com.azure.resourcemanager.test.policy.HttpDebugLoggingPolicy;
import com.azure.resourcemanager.test.utils.CliRunner;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import reactor.core.Exceptions;

public abstract class ResourceManagerTestProxyTestBase
extends TestProxyTestBase {
    private static final String ZERO_UUID = "00000000-0000-0000-0000-000000000000";
    private static final String SUBSCRIPTION_ID_REGEX = "(?<=/subscriptions/)([^/?]+)";
    private static final String ZERO_SUBSCRIPTION = "00000000-0000-0000-0000-000000000000";
    private static final String ZERO_TENANT = "00000000-0000-0000-0000-000000000000";
    private static final String PLAYBACK_URI_BASE = "https://localhost:";
    private static final String AZURE_AUTH_LOCATION = "AZURE_AUTH_LOCATION";
    private static final String AZURE_TEST_LOG_LEVEL = "AZURE_TEST_LOG_LEVEL";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String USE_SYSTEM_PROXY = "java.net.useSystemProxies";
    private static final String VALUE_TRUE = "true";
    private static final String PLAYBACK_URI = "https://localhost:1234";
    private static final AzureProfile PLAYBACK_PROFILE = new AzureProfile("00000000-0000-0000-0000-000000000000", "00000000-0000-0000-0000-000000000000", new AzureEnvironment(Arrays.stream(AzureEnvironment.Endpoint.values()).collect(Collectors.toMap(AzureEnvironment.Endpoint::identifier, endpoint -> "https://localhost:1234"))));
    private static final OutputStream EMPTY_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    };
    protected static final String REDACTED_VALUE = "REDACTED";
    private static final ClientLogger LOGGER = new ClientLogger(ResourceManagerTestProxyTestBase.class);
    private AzureProfile testProfile;
    private boolean isSkipInPlayback;
    private final List<TestProxySanitizer> sanitizers = new ArrayList<TestProxySanitizer>();
    @RegisterExtension
    final PlaybackTimeoutInterceptor playbackTimeoutInterceptor = new PlaybackTimeoutInterceptor(() -> Duration.ofSeconds(120L));
    private static String sshPublicKey;
    private static final Pattern SUBSCRIPTION_ID_PATTERN;

    protected ResourceManagerTestProxyTestBase() {
    }

    protected String generateRandomResourceName(String prefix, int maxLen) {
        return this.testResourceNamer.randomName(prefix, maxLen);
    }

    protected String generateRandomUuid() {
        return this.testResourceNamer.randomUuid();
    }

    public static String password() {
        String password = new ResourceNamer("").randomName("Pa5$", 12);
        LOGGER.info("Password: {}", new Object[]{password});
        return password;
    }

    public static String sshPublicKey() {
        if (sshPublicKey == null) {
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                keyGen.initialize(1024);
                KeyPair pair = keyGen.generateKeyPair();
                PublicKey publicKey = pair.getPublic();
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(byteOs);
                dos.writeInt("ssh-rsa".getBytes(StandardCharsets.US_ASCII).length);
                dos.write("ssh-rsa".getBytes(StandardCharsets.US_ASCII));
                dos.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
                dos.write(rsaPublicKey.getPublicExponent().toByteArray());
                dos.writeInt(rsaPublicKey.getModulus().toByteArray().length);
                dos.write(rsaPublicKey.getModulus().toByteArray());
                String publicKeyEncoded = new String(Base64.getEncoder().encode(byteOs.toByteArray()), StandardCharsets.US_ASCII);
                sshPublicKey = "ssh-rsa " + publicKeyEncoded;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("failed to generate ssh key", e));
            }
        }
        return sshPublicKey;
    }

    protected void assertResourceIdEquals(String expected, String actual) {
        String sanitizedExpected = SUBSCRIPTION_ID_PATTERN.matcher(expected).replaceAll("00000000-0000-0000-0000-000000000000");
        String sanitizedActual = SUBSCRIPTION_ID_PATTERN.matcher(actual).replaceAll("00000000-0000-0000-0000-000000000000");
        Assertions.assertTrue((boolean)sanitizedExpected.equalsIgnoreCase(sanitizedActual), (String)String.format("expected: %s but was: %s", expected, actual));
    }

    protected String clientIdFromFile() {
        String clientId = Configuration.getGlobalConfiguration().get("AZURE_CLIENT_ID");
        return this.testResourceNamer.recordValueFromConfig(clientId);
    }

    protected AzureUser azureCliSignedInUser() {
        AzureUser azureCliUser = new AzureUser(this.testResourceNamer);
        if (!this.isPlaybackMode()) {
            String azCommand = "az ad signed-in-user show --output json";
            try {
                String processOutput = CliRunner.run(azCommand);
                try (JsonReader reader = JsonProviders.createReader((String)processOutput);){
                    Map signedInUserInfo = reader.readMap(JsonReader::readUntyped);
                    String userPrincipalName = (String)signedInUserInfo.get("userPrincipalName");
                    String id = (String)signedInUserInfo.get("id");
                    azureCliUser = new AzureUser(this.testResourceNamer, id, userPrincipalName);
                }
            }
            catch (IOException | InterruptedException e) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
            }
        }
        return azureCliUser;
    }

    protected AzureProfile profile() {
        return this.testProfile;
    }

    protected boolean isPlaybackMode() {
        return this.getTestMode() == TestMode.PLAYBACK;
    }

    protected boolean skipInPlayback() {
        if (this.isPlaybackMode()) {
            this.isSkipInPlayback = true;
        }
        return this.isSkipInPlayback;
    }

    protected void beforeTest() {
        HttpPipeline httpPipeline;
        HttpLogDetailLevel httpLogDetailLevel;
        String logLevel = Configuration.getGlobalConfiguration().get(AZURE_TEST_LOG_LEVEL);
        try {
            httpLogDetailLevel = HttpLogDetailLevel.valueOf((String)logLevel);
        }
        catch (Exception e) {
            if (this.isPlaybackMode()) {
                httpLogDetailLevel = HttpLogDetailLevel.NONE;
                LOGGER.error("Environment variable '{}' has not been set yet. Using 'NONE' for PLAYBACK.", new Object[]{AZURE_TEST_LOG_LEVEL});
            }
            httpLogDetailLevel = HttpLogDetailLevel.BODY_AND_HEADERS;
            LOGGER.error("Environment variable '{}' has not been set yet. Using 'BODY_AND_HEADERS' for RECORD/LIVE.", new Object[]{AZURE_TEST_LOG_LEVEL});
        }
        if (httpLogDetailLevel == HttpLogDetailLevel.NONE) {
            try {
                System.setOut(new PrintStream(EMPTY_OUTPUT_STREAM, false, Charset.defaultCharset().name()));
                System.setErr(new PrintStream(EMPTY_OUTPUT_STREAM, false, Charset.defaultCharset().name()));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (this.isPlaybackMode()) {
            this.testProfile = PLAYBACK_PROFILE;
            ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
            httpPipeline = this.buildHttpPipeline((TokenCredential)new MockTokenCredential(), this.testProfile, new HttpLogOptions().setLogLevel(httpLogDetailLevel), policies, this.interceptorManager.getPlaybackClient());
            if (!this.testContextManager.doNotRecordTest()) {
                this.interceptorManager.addMatchers(Collections.singletonList(new CustomMatcher().setIgnoredQueryParameters(Arrays.asList("api-version")).setExcludedHeaders(Arrays.asList("If-Match")).setQueryOrderingIgnored(true)));
                this.addSanitizers();
                this.removeSanitizers();
            }
        } else {
            Configuration configuration = Configuration.getGlobalConfiguration();
            String tenantId = Objects.requireNonNull(configuration.get("AZURE_TENANT_ID"), "'AZURE_TENANT_ID' environment variable cannot be null.");
            String subscriptionId = Objects.requireNonNull(configuration.get("AZURE_SUBSCRIPTION_ID"), "'AZURE_SUBSCRIPTION_ID' environment variable cannot be null.");
            this.testProfile = new AzureProfile(tenantId, subscriptionId, AzureCloud.AZURE_PUBLIC_CLOUD);
            DefaultAzureCredential credential = new DefaultAzureCredentialBuilder().authorityHost(this.testProfile.getEnvironment().getActiveDirectoryEndpoint()).build();
            ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
            if (this.interceptorManager.isRecordMode() && !this.testContextManager.doNotRecordTest()) {
                policies.add(this.interceptorManager.getRecordPolicy());
                this.addSanitizers();
                this.removeSanitizers();
            }
            if (httpLogDetailLevel == HttpLogDetailLevel.BODY_AND_HEADERS) {
                policies.add(new HttpDebugLoggingPolicy());
                httpLogDetailLevel = HttpLogDetailLevel.NONE;
            }
            httpPipeline = this.buildHttpPipeline((TokenCredential)credential, this.testProfile, new HttpLogOptions().setLogLevel(httpLogDetailLevel), policies, this.generateHttpClientWithProxy(null, null));
        }
        this.initializeClients(httpPipeline, this.testProfile);
    }

    protected HttpClient generateHttpClientWithProxy(NettyAsyncHttpClientBuilder clientBuilder, ProxyOptions proxyOptions) {
        if (clientBuilder == null) {
            clientBuilder = new NettyAsyncHttpClientBuilder();
        }
        if (proxyOptions != null) {
            clientBuilder.proxy(proxyOptions);
        } else {
            try {
                System.setProperty(USE_SYSTEM_PROXY, VALUE_TRUE);
                List<Proxy> proxies = ProxySelector.getDefault().select(new URI(AzureEnvironment.AZURE.getResourceManagerEndpoint()));
                if (!proxies.isEmpty()) {
                    for (Proxy proxy : proxies) {
                        if (!(proxy.address() instanceof InetSocketAddress)) continue;
                        String host = ((InetSocketAddress)proxy.address()).getHostName();
                        int port = ((InetSocketAddress)proxy.address()).getPort();
                        switch (proxy.type()) {
                            case HTTP: {
                                return clientBuilder.proxy(new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(host, port))).build();
                            }
                            case SOCKS: {
                                return clientBuilder.proxy(new ProxyOptions(ProxyOptions.Type.SOCKS5, new InetSocketAddress(host, port))).build();
                            }
                        }
                    }
                }
                String host = null;
                int port = 0;
                if (System.getProperty(HTTPS_PROXY_HOST) != null && System.getProperty(HTTPS_PROXY_PORT) != null) {
                    host = System.getProperty(HTTPS_PROXY_HOST);
                    port = Integer.parseInt(System.getProperty(HTTPS_PROXY_PORT));
                } else if (System.getProperty(HTTP_PROXY_HOST) != null && System.getProperty(HTTP_PROXY_PORT) != null) {
                    host = System.getProperty(HTTP_PROXY_HOST);
                    port = Integer.parseInt(System.getProperty(HTTP_PROXY_PORT));
                }
                if (host != null) {
                    clientBuilder.proxy(new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(host, port)));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return clientBuilder.build();
    }

    protected void afterTest() {
        if (!this.isSkipInPlayback) {
            this.cleanUpResources();
        }
    }

    protected <T> void setInternalContext(T internalContext, Object ... objects) {
        try {
            for (Object obj : objects) {
                for (Field field : obj.getClass().getSuperclass().getDeclaredFields()) {
                    if (!field.getName().equals("resourceManager")) continue;
                    this.setAccessible(field);
                    Field context = field.get(obj).getClass().getDeclaredField("internalContext");
                    this.setAccessible(context);
                    context.set(field.get(obj), internalContext);
                }
                for (Field field : obj.getClass().getDeclaredFields()) {
                    if (field.getName().equals("internalContext")) {
                        this.setAccessible(field);
                        field.set(obj, internalContext);
                        continue;
                    }
                    if (!field.getName().contains("Manager")) continue;
                    this.setAccessible(field);
                    this.setInternalContext(internalContext, field.get(obj));
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw LOGGER.logExceptionAsError(new RuntimeException(ex));
        }
    }

    private void setAccessible(AccessibleObject accessibleObject) {
        Runnable runnable = () -> accessibleObject.setAccessible(true);
        runnable.run();
    }

    protected <T> T buildManager(Class<T> manager, HttpPipeline httpPipeline, AzureProfile profile) {
        try {
            Constructor<T> constructor = manager.getDeclaredConstructor(httpPipeline.getClass(), profile.getClass());
            this.setAccessible(constructor);
            return constructor.newInstance(httpPipeline, profile);
        }
        catch (ReflectiveOperationException ex) {
            throw LOGGER.logExceptionAsError(new RuntimeException(ex));
        }
    }

    protected abstract HttpPipeline buildHttpPipeline(TokenCredential var1, AzureProfile var2, HttpLogOptions var3, List<HttpPipelinePolicy> var4, HttpClient var5);

    protected abstract void initializeClients(HttpPipeline var1, AzureProfile var2);

    protected abstract void cleanUpResources();

    private void addSanitizers() {
        ArrayList<TestProxySanitizer> sanitizers = new ArrayList<TestProxySanitizer>(Arrays.asList(new TestProxySanitizer(SUBSCRIPTION_ID_REGEX, "00000000-0000-0000-0000-000000000000", TestProxySanitizerType.URL), new TestProxySanitizer("(?<=%2Fsubscriptions%2F)([^/?]+)", "00000000-0000-0000-0000-000000000000", TestProxySanitizerType.URL), new TestProxySanitizer("Retry-After", null, "0", TestProxySanitizerType.HEADER), new TestProxySanitizer("$..id", SUBSCRIPTION_ID_REGEX, "00000000-0000-0000-0000-000000000000", TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..secretText", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..keys[*].value", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..adminPassword", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..Password", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..accessSAS", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$.properties.osProfile.customData", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..administratorLoginPassword", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..hubDatabasePassword", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..aliasPrimaryConnectionString", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..aliasSecondaryConnectionString", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..primaryKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..secondaryKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..primaryMasterKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..secondaryMasterKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..primaryReadonlyMasterKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..secondaryReadonlyMasterKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..passwords[*].value", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..secret", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$..storageAccountKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$.properties.siteConfig.machineKey.decryptionKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("(?:AccountKey=)(?<accountKey>.*?)(?:;)", REDACTED_VALUE, TestProxySanitizerType.BODY_REGEX).setGroupForReplace("accountKey"), new TestProxySanitizer("$.properties.WEBSITE_AUTH_ENCRYPTION_KEY", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$.properties.DOCKER_REGISTRY_SERVER_PASSWORD", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY), new TestProxySanitizer("$.properties.protectedSettings.storageAccountKey", null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY)));
        sanitizers.addAll(this.sanitizers);
        this.interceptorManager.addSanitizers(sanitizers);
    }

    private void removeSanitizers() {
        this.interceptorManager.removeSanitizers(new String[]{"AZSDK2003", "AZSDK2030", "AZSDK3430", "AZSDK3493"});
    }

    protected void addSanitizers(TestProxySanitizer ... sanitizers) {
        this.sanitizers.addAll(Arrays.asList(sanitizers));
    }

    static {
        SUBSCRIPTION_ID_PATTERN = Pattern.compile(SUBSCRIPTION_ID_REGEX);
    }

    private final class PlaybackTimeoutInterceptor
    implements InvocationInterceptor {
        private final Duration duration;

        private PlaybackTimeoutInterceptor(Supplier<Duration> timeoutSupplier) {
            Objects.requireNonNull(timeoutSupplier);
            this.duration = timeoutSupplier.get();
        }

        public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
            if (ResourceManagerTestProxyTestBase.this.isPlaybackMode()) {
                Assertions.assertTimeoutPreemptively((Duration)this.duration, () -> invocation.proceed());
            } else {
                invocation.proceed();
            }
        }
    }
}

