/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.UsageModelInner;
import java.io.IOException;
import java.util.List;

public final class UsageModelsResult
implements JsonSerializable<UsageModelsResult> {
    private String nextLink;
    private List<UsageModelInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public UsageModelsResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<UsageModelInner> value() {
        return this.value;
    }

    public UsageModelsResult withValue(List<UsageModelInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static UsageModelsResult fromJson(JsonReader jsonReader) throws IOException {
        return (UsageModelsResult)jsonReader.readObject(reader -> {
            UsageModelsResult deserializedUsageModelsResult = new UsageModelsResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedUsageModelsResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedUsageModelsResult.value = value = reader.readArray(reader1 -> UsageModelInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageModelsResult;
        });
    }
}

