/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.fluent.models.StorageTargetInner;
import com.azure.resourcemanager.storagecache.models.BlobNfsTarget;
import com.azure.resourcemanager.storagecache.models.ClfsTarget;
import com.azure.resourcemanager.storagecache.models.NamespaceJunction;
import com.azure.resourcemanager.storagecache.models.Nfs3Target;
import com.azure.resourcemanager.storagecache.models.OperationalStateType;
import com.azure.resourcemanager.storagecache.models.ProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.StorageTargetType;
import com.azure.resourcemanager.storagecache.models.UnknownTarget;
import java.util.List;

public interface StorageTarget {
    public String id();

    public String name();

    public String type();

    public String location();

    public SystemData systemData();

    public List<NamespaceJunction> junctions();

    public StorageTargetType targetType();

    public ProvisioningStateType provisioningState();

    public OperationalStateType state();

    public Nfs3Target nfs3();

    public ClfsTarget clfs();

    public UnknownTarget unknown();

    public BlobNfsTarget blobNfs();

    public Integer allocationPercentage();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public StorageTargetInner innerModel();

    public Update update();

    public StorageTarget refresh();

    public StorageTarget refresh(Context var1);

    public void dnsRefresh();

    public void dnsRefresh(Context var1);

    public static interface UpdateStages {

        public static interface WithBlobNfs {
            public Update withBlobNfs(BlobNfsTarget var1);
        }

        public static interface WithUnknown {
            public Update withUnknown(UnknownTarget var1);
        }

        public static interface WithClfs {
            public Update withClfs(ClfsTarget var1);
        }

        public static interface WithNfs3 {
            public Update withNfs3(Nfs3Target var1);
        }

        public static interface WithState {
            public Update withState(OperationalStateType var1);
        }

        public static interface WithJunctions {
            public Update withJunctions(List<NamespaceJunction> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithJunctions,
    UpdateStages.WithState,
    UpdateStages.WithNfs3,
    UpdateStages.WithClfs,
    UpdateStages.WithUnknown,
    UpdateStages.WithBlobNfs {
        public StorageTarget apply();

        public StorageTarget apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithBlobNfs {
            public WithCreate withBlobNfs(BlobNfsTarget var1);
        }

        public static interface WithUnknown {
            public WithCreate withUnknown(UnknownTarget var1);
        }

        public static interface WithClfs {
            public WithCreate withClfs(ClfsTarget var1);
        }

        public static interface WithNfs3 {
            public WithCreate withNfs3(Nfs3Target var1);
        }

        public static interface WithState {
            public WithCreate withState(OperationalStateType var1);
        }

        public static interface WithTargetType {
            public WithCreate withTargetType(StorageTargetType var1);
        }

        public static interface WithJunctions {
            public WithCreate withJunctions(List<NamespaceJunction> var1);
        }

        public static interface WithCreate
        extends WithJunctions,
        WithTargetType,
        WithState,
        WithNfs3,
        WithClfs,
        WithUnknown,
        WithBlobNfs {
            public StorageTarget create();

            public StorageTarget create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingCache(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

