/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.NfsAccessRuleAccess;
import com.azure.resourcemanager.storagecache.models.NfsAccessRuleScope;
import java.io.IOException;

public final class NfsAccessRule
implements JsonSerializable<NfsAccessRule> {
    private NfsAccessRuleScope scope;
    private String filter;
    private NfsAccessRuleAccess access;
    private Boolean suid;
    private Boolean submountAccess;
    private Boolean rootSquash;
    private String anonymousUid;
    private String anonymousGid;
    private static final ClientLogger LOGGER = new ClientLogger(NfsAccessRule.class);

    public NfsAccessRuleScope scope() {
        return this.scope;
    }

    public NfsAccessRule withScope(NfsAccessRuleScope scope) {
        this.scope = scope;
        return this;
    }

    public String filter() {
        return this.filter;
    }

    public NfsAccessRule withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public NfsAccessRuleAccess access() {
        return this.access;
    }

    public NfsAccessRule withAccess(NfsAccessRuleAccess access) {
        this.access = access;
        return this;
    }

    public Boolean suid() {
        return this.suid;
    }

    public NfsAccessRule withSuid(Boolean suid) {
        this.suid = suid;
        return this;
    }

    public Boolean submountAccess() {
        return this.submountAccess;
    }

    public NfsAccessRule withSubmountAccess(Boolean submountAccess) {
        this.submountAccess = submountAccess;
        return this;
    }

    public Boolean rootSquash() {
        return this.rootSquash;
    }

    public NfsAccessRule withRootSquash(Boolean rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public String anonymousUid() {
        return this.anonymousUid;
    }

    public NfsAccessRule withAnonymousUid(String anonymousUid) {
        this.anonymousUid = anonymousUid;
        return this;
    }

    public String anonymousGid() {
        return this.anonymousGid;
    }

    public NfsAccessRule withAnonymousGid(String anonymousGid) {
        this.anonymousGid = anonymousGid;
        return this;
    }

    public void validate() {
        if (this.scope() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scope in model NfsAccessRule"));
        }
        if (this.access() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property access in model NfsAccessRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeBooleanField("suid", this.suid);
        jsonWriter.writeBooleanField("submountAccess", this.submountAccess);
        jsonWriter.writeBooleanField("rootSquash", this.rootSquash);
        jsonWriter.writeStringField("anonymousUID", this.anonymousUid);
        jsonWriter.writeStringField("anonymousGID", this.anonymousGid);
        return jsonWriter.writeEndObject();
    }

    public static NfsAccessRule fromJson(JsonReader jsonReader) throws IOException {
        return (NfsAccessRule)jsonReader.readObject(reader -> {
            NfsAccessRule deserializedNfsAccessRule = new NfsAccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedNfsAccessRule.scope = NfsAccessRuleScope.fromString(reader.getString());
                    continue;
                }
                if ("access".equals(fieldName)) {
                    deserializedNfsAccessRule.access = NfsAccessRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedNfsAccessRule.filter = reader.getString();
                    continue;
                }
                if ("suid".equals(fieldName)) {
                    deserializedNfsAccessRule.suid = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("submountAccess".equals(fieldName)) {
                    deserializedNfsAccessRule.submountAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("rootSquash".equals(fieldName)) {
                    deserializedNfsAccessRule.rootSquash = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("anonymousUID".equals(fieldName)) {
                    deserializedNfsAccessRule.anonymousUid = reader.getString();
                    continue;
                }
                if ("anonymousGID".equals(fieldName)) {
                    deserializedNfsAccessRule.anonymousGid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNfsAccessRule;
        });
    }
}

