/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.ImportJobInner;
import java.io.IOException;
import java.util.List;

public final class ImportJobsListResult
implements JsonSerializable<ImportJobsListResult> {
    private String nextLink;
    private List<ImportJobInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ImportJobsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ImportJobInner> value() {
        return this.value;
    }

    public ImportJobsListResult withValue(List<ImportJobInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ImportJobsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ImportJobsListResult)jsonReader.readObject(reader -> {
            ImportJobsListResult deserializedImportJobsListResult = new ImportJobsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedImportJobsListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedImportJobsListResult.value = value = reader.readArray(reader1 -> ImportJobInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportJobsListResult;
        });
    }
}

