/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.ImportJobUpdateProperties;
import com.azure.resourcemanager.storagecache.models.ImportJobAdminStatus;
import java.io.IOException;
import java.util.Map;

public final class ImportJobUpdate
implements JsonSerializable<ImportJobUpdate> {
    private Map<String, String> tags;
    private ImportJobUpdateProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ImportJobUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private ImportJobUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public ImportJobAdminStatus adminStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().adminStatus();
    }

    public ImportJobUpdate withAdminStatus(ImportJobAdminStatus adminStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImportJobUpdateProperties();
        }
        this.innerProperties().withAdminStatus(adminStatus);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ImportJobUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ImportJobUpdate)jsonReader.readObject(reader -> {
            ImportJobUpdate deserializedImportJobUpdate = new ImportJobUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedImportJobUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedImportJobUpdate.innerProperties = ImportJobUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportJobUpdate;
        });
    }
}

