/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.fluent.models.ImportJobInner;
import com.azure.resourcemanager.storagecache.models.ConflictResolutionMode;
import com.azure.resourcemanager.storagecache.models.ImportJobAdminStatus;
import com.azure.resourcemanager.storagecache.models.ImportJobProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.ImportStatusType;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface ImportJob {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public ImportJobProvisioningStateType provisioningState();

    public ImportJobAdminStatus adminStatus();

    public List<String> importPrefixes();

    public ConflictResolutionMode conflictResolutionMode();

    public Integer maximumErrors();

    public ImportStatusType state();

    public String statusMessage();

    public Long totalBlobsWalked();

    public Long blobsWalkedPerSecond();

    public Long totalBlobsImported();

    public Long importedFiles();

    public Long importedDirectories();

    public Long importedSymlinks();

    public Long preexistingFiles();

    public Long preexistingDirectories();

    public Long preexistingSymlinks();

    public Long blobsImportedPerSecond();

    public OffsetDateTime lastCompletionTime();

    public OffsetDateTime lastStartedTime();

    public Integer totalErrors();

    public Integer totalConflicts();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ImportJobInner innerModel();

    public Update update();

    public ImportJob refresh();

    public ImportJob refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithAdminStatus {
            public Update withAdminStatus(ImportJobAdminStatus var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithAdminStatus {
        public ImportJob apply();

        public ImportJob apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMaximumErrors {
            public WithCreate withMaximumErrors(Integer var1);
        }

        public static interface WithConflictResolutionMode {
            public WithCreate withConflictResolutionMode(ConflictResolutionMode var1);
        }

        public static interface WithImportPrefixes {
            public WithCreate withImportPrefixes(List<String> var1);
        }

        public static interface WithAdminStatus {
            public WithCreate withAdminStatus(ImportJobAdminStatus var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithAdminStatus,
        WithImportPrefixes,
        WithConflictResolutionMode,
        WithMaximumErrors {
            public ImportJob create();

            public ImportJob create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAmlFilesystem(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

