/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.FirmwareStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CacheUpgradeStatus
implements JsonSerializable<CacheUpgradeStatus> {
    private String currentFirmwareVersion;
    private FirmwareStatusType firmwareUpdateStatus;
    private OffsetDateTime firmwareUpdateDeadline;
    private OffsetDateTime lastFirmwareUpdate;
    private String pendingFirmwareVersion;

    public String currentFirmwareVersion() {
        return this.currentFirmwareVersion;
    }

    public FirmwareStatusType firmwareUpdateStatus() {
        return this.firmwareUpdateStatus;
    }

    public OffsetDateTime firmwareUpdateDeadline() {
        return this.firmwareUpdateDeadline;
    }

    public OffsetDateTime lastFirmwareUpdate() {
        return this.lastFirmwareUpdate;
    }

    public String pendingFirmwareVersion() {
        return this.pendingFirmwareVersion;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static CacheUpgradeStatus fromJson(JsonReader jsonReader) throws IOException {
        return (CacheUpgradeStatus)jsonReader.readObject(reader -> {
            CacheUpgradeStatus deserializedCacheUpgradeStatus = new CacheUpgradeStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("currentFirmwareVersion".equals(fieldName)) {
                    deserializedCacheUpgradeStatus.currentFirmwareVersion = reader.getString();
                    continue;
                }
                if ("firmwareUpdateStatus".equals(fieldName)) {
                    deserializedCacheUpgradeStatus.firmwareUpdateStatus = FirmwareStatusType.fromString(reader.getString());
                    continue;
                }
                if ("firmwareUpdateDeadline".equals(fieldName)) {
                    deserializedCacheUpgradeStatus.firmwareUpdateDeadline = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastFirmwareUpdate".equals(fieldName)) {
                    deserializedCacheUpgradeStatus.lastFirmwareUpdate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("pendingFirmwareVersion".equals(fieldName)) {
                    deserializedCacheUpgradeStatus.pendingFirmwareVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheUpgradeStatus;
        });
    }
}

