/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.NfsAccessPolicy;
import java.io.IOException;
import java.util.List;

public final class CacheSecuritySettings
implements JsonSerializable<CacheSecuritySettings> {
    private List<NfsAccessPolicy> accessPolicies;

    public List<NfsAccessPolicy> accessPolicies() {
        return this.accessPolicies;
    }

    public CacheSecuritySettings withAccessPolicies(List<NfsAccessPolicy> accessPolicies) {
        this.accessPolicies = accessPolicies;
        return this;
    }

    public void validate() {
        if (this.accessPolicies() != null) {
            this.accessPolicies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("accessPolicies", this.accessPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CacheSecuritySettings fromJson(JsonReader jsonReader) throws IOException {
        return (CacheSecuritySettings)jsonReader.readObject(reader -> {
            CacheSecuritySettings deserializedCacheSecuritySettings = new CacheSecuritySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessPolicies".equals(fieldName)) {
                    List accessPolicies;
                    deserializedCacheSecuritySettings.accessPolicies = accessPolicies = reader.readArray(reader1 -> NfsAccessPolicy.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheSecuritySettings;
        });
    }
}

