/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.KeyVaultKeyReference;
import java.io.IOException;

public final class CacheEncryptionSettings
implements JsonSerializable<CacheEncryptionSettings> {
    private KeyVaultKeyReference keyEncryptionKey;
    private Boolean rotationToLatestKeyVersionEnabled;

    public KeyVaultKeyReference keyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    public CacheEncryptionSettings withKeyEncryptionKey(KeyVaultKeyReference keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        return this;
    }

    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.rotationToLatestKeyVersionEnabled;
    }

    public CacheEncryptionSettings withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        this.rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled;
        return this;
    }

    public void validate() {
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keyEncryptionKey", (JsonSerializable)this.keyEncryptionKey);
        jsonWriter.writeBooleanField("rotationToLatestKeyVersionEnabled", this.rotationToLatestKeyVersionEnabled);
        return jsonWriter.writeEndObject();
    }

    public static CacheEncryptionSettings fromJson(JsonReader jsonReader) throws IOException {
        return (CacheEncryptionSettings)jsonReader.readObject(reader -> {
            CacheEncryptionSettings deserializedCacheEncryptionSettings = new CacheEncryptionSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedCacheEncryptionSettings.keyEncryptionKey = KeyVaultKeyReference.fromJson(reader);
                    continue;
                }
                if ("rotationToLatestKeyVersionEnabled".equals(fieldName)) {
                    deserializedCacheEncryptionSettings.rotationToLatestKeyVersionEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheEncryptionSettings;
        });
    }
}

