/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.CacheActiveDirectorySettingsCredentials;
import com.azure.resourcemanager.storagecache.models.DomainJoinedType;
import java.io.IOException;

public final class CacheActiveDirectorySettings
implements JsonSerializable<CacheActiveDirectorySettings> {
    private String primaryDnsIpAddress;
    private String secondaryDnsIpAddress;
    private String domainName;
    private String domainNetBiosName;
    private String cacheNetBiosName;
    private DomainJoinedType domainJoined;
    private CacheActiveDirectorySettingsCredentials credentials;
    private static final ClientLogger LOGGER = new ClientLogger(CacheActiveDirectorySettings.class);

    public String primaryDnsIpAddress() {
        return this.primaryDnsIpAddress;
    }

    public CacheActiveDirectorySettings withPrimaryDnsIpAddress(String primaryDnsIpAddress) {
        this.primaryDnsIpAddress = primaryDnsIpAddress;
        return this;
    }

    public String secondaryDnsIpAddress() {
        return this.secondaryDnsIpAddress;
    }

    public CacheActiveDirectorySettings withSecondaryDnsIpAddress(String secondaryDnsIpAddress) {
        this.secondaryDnsIpAddress = secondaryDnsIpAddress;
        return this;
    }

    public String domainName() {
        return this.domainName;
    }

    public CacheActiveDirectorySettings withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String domainNetBiosName() {
        return this.domainNetBiosName;
    }

    public CacheActiveDirectorySettings withDomainNetBiosName(String domainNetBiosName) {
        this.domainNetBiosName = domainNetBiosName;
        return this;
    }

    public String cacheNetBiosName() {
        return this.cacheNetBiosName;
    }

    public CacheActiveDirectorySettings withCacheNetBiosName(String cacheNetBiosName) {
        this.cacheNetBiosName = cacheNetBiosName;
        return this;
    }

    public DomainJoinedType domainJoined() {
        return this.domainJoined;
    }

    public CacheActiveDirectorySettingsCredentials credentials() {
        return this.credentials;
    }

    public CacheActiveDirectorySettings withCredentials(CacheActiveDirectorySettingsCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public void validate() {
        if (this.primaryDnsIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property primaryDnsIpAddress in model CacheActiveDirectorySettings"));
        }
        if (this.domainName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domainName in model CacheActiveDirectorySettings"));
        }
        if (this.domainNetBiosName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domainNetBiosName in model CacheActiveDirectorySettings"));
        }
        if (this.cacheNetBiosName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cacheNetBiosName in model CacheActiveDirectorySettings"));
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primaryDnsIpAddress", this.primaryDnsIpAddress);
        jsonWriter.writeStringField("domainName", this.domainName);
        jsonWriter.writeStringField("domainNetBiosName", this.domainNetBiosName);
        jsonWriter.writeStringField("cacheNetBiosName", this.cacheNetBiosName);
        jsonWriter.writeStringField("secondaryDnsIpAddress", this.secondaryDnsIpAddress);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        return jsonWriter.writeEndObject();
    }

    public static CacheActiveDirectorySettings fromJson(JsonReader jsonReader) throws IOException {
        return (CacheActiveDirectorySettings)jsonReader.readObject(reader -> {
            CacheActiveDirectorySettings deserializedCacheActiveDirectorySettings = new CacheActiveDirectorySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("primaryDnsIpAddress".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettings.primaryDnsIpAddress = reader.getString();
                    continue;
                }
                if ("domainName".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettings.domainName = reader.getString();
                    continue;
                }
                if ("domainNetBiosName".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettings.domainNetBiosName = reader.getString();
                    continue;
                }
                if ("cacheNetBiosName".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettings.cacheNetBiosName = reader.getString();
                    continue;
                }
                if ("secondaryDnsIpAddress".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettings.secondaryDnsIpAddress = reader.getString();
                    continue;
                }
                if ("domainJoined".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettings.domainJoined = DomainJoinedType.fromString(reader.getString());
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettings.credentials = CacheActiveDirectorySettingsCredentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheActiveDirectorySettings;
        });
    }
}

