/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.fluent.models.CacheInner;
import com.azure.resourcemanager.storagecache.models.CacheDirectorySettings;
import com.azure.resourcemanager.storagecache.models.CacheEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.CacheHealth;
import com.azure.resourcemanager.storagecache.models.CacheIdentity;
import com.azure.resourcemanager.storagecache.models.CacheNetworkSettings;
import com.azure.resourcemanager.storagecache.models.CacheSecuritySettings;
import com.azure.resourcemanager.storagecache.models.CacheSku;
import com.azure.resourcemanager.storagecache.models.CacheUpgradeSettings;
import com.azure.resourcemanager.storagecache.models.CacheUpgradeStatus;
import com.azure.resourcemanager.storagecache.models.PrimingJob;
import com.azure.resourcemanager.storagecache.models.PrimingJobIdParameter;
import com.azure.resourcemanager.storagecache.models.ProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.StorageTargetSpaceAllocation;
import java.util.List;
import java.util.Map;

public interface Cache {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public CacheIdentity identity();

    public SystemData systemData();

    public CacheSku sku();

    public Integer cacheSizeGB();

    public CacheHealth health();

    public List<String> mountAddresses();

    public ProvisioningStateType provisioningState();

    public String subnet();

    public CacheUpgradeStatus upgradeStatus();

    public CacheUpgradeSettings upgradeSettings();

    public CacheNetworkSettings networkSettings();

    public CacheEncryptionSettings encryptionSettings();

    public CacheSecuritySettings securitySettings();

    public CacheDirectorySettings directoryServicesSettings();

    public List<String> zones();

    public List<PrimingJob> primingJobs();

    public List<StorageTargetSpaceAllocation> spaceAllocation();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public CacheInner innerModel();

    public Update update();

    public Cache refresh();

    public Cache refresh(Context var1);

    public void debugInfo();

    public void debugInfo(Context var1);

    public void flush();

    public void flush(Context var1);

    public void start();

    public void start(Context var1);

    public void stop();

    public void stop(Context var1);

    public void startPrimingJob();

    public void startPrimingJob(PrimingJob var1, Context var2);

    public void stopPrimingJob();

    public void stopPrimingJob(PrimingJobIdParameter var1, Context var2);

    public void pausePrimingJob();

    public void pausePrimingJob(PrimingJobIdParameter var1, Context var2);

    public void resumePrimingJob();

    public void resumePrimingJob(PrimingJobIdParameter var1, Context var2);

    public void upgradeFirmware();

    public void upgradeFirmware(Context var1);

    public static interface UpdateStages {

        public static interface WithDirectoryServicesSettings {
            public Update withDirectoryServicesSettings(CacheDirectorySettings var1);
        }

        public static interface WithSecuritySettings {
            public Update withSecuritySettings(CacheSecuritySettings var1);
        }

        public static interface WithEncryptionSettings {
            public Update withEncryptionSettings(CacheEncryptionSettings var1);
        }

        public static interface WithNetworkSettings {
            public Update withNetworkSettings(CacheNetworkSettings var1);
        }

        public static interface WithUpgradeSettings {
            public Update withUpgradeSettings(CacheUpgradeSettings var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(CacheIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithUpgradeSettings,
    UpdateStages.WithNetworkSettings,
    UpdateStages.WithEncryptionSettings,
    UpdateStages.WithSecuritySettings,
    UpdateStages.WithDirectoryServicesSettings {
        public Cache apply();

        public Cache apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithDirectoryServicesSettings {
            public WithCreate withDirectoryServicesSettings(CacheDirectorySettings var1);
        }

        public static interface WithSecuritySettings {
            public WithCreate withSecuritySettings(CacheSecuritySettings var1);
        }

        public static interface WithEncryptionSettings {
            public WithCreate withEncryptionSettings(CacheEncryptionSettings var1);
        }

        public static interface WithNetworkSettings {
            public WithCreate withNetworkSettings(CacheNetworkSettings var1);
        }

        public static interface WithUpgradeSettings {
            public WithCreate withUpgradeSettings(CacheUpgradeSettings var1);
        }

        public static interface WithSubnet {
            public WithCreate withSubnet(String var1);
        }

        public static interface WithCacheSizeGB {
            public WithCreate withCacheSizeGB(Integer var1);
        }

        public static interface WithSku {
            public WithCreate withSku(CacheSku var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(CacheIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithSku,
        WithCacheSizeGB,
        WithSubnet,
        WithUpgradeSettings,
        WithNetworkSettings,
        WithEncryptionSettings,
        WithSecuritySettings,
        WithDirectoryServicesSettings,
        WithZones {
            public Cache create();

            public Cache create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

