/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AmlFilesystemHsmSettings
implements JsonSerializable<AmlFilesystemHsmSettings> {
    private String container;
    private String loggingContainer;
    private String importPrefix;
    private List<String> importPrefixesInitial;
    private static final ClientLogger LOGGER = new ClientLogger(AmlFilesystemHsmSettings.class);

    public String container() {
        return this.container;
    }

    public AmlFilesystemHsmSettings withContainer(String container) {
        this.container = container;
        return this;
    }

    public String loggingContainer() {
        return this.loggingContainer;
    }

    public AmlFilesystemHsmSettings withLoggingContainer(String loggingContainer) {
        this.loggingContainer = loggingContainer;
        return this;
    }

    public String importPrefix() {
        return this.importPrefix;
    }

    public AmlFilesystemHsmSettings withImportPrefix(String importPrefix) {
        this.importPrefix = importPrefix;
        return this;
    }

    public List<String> importPrefixesInitial() {
        return this.importPrefixesInitial;
    }

    public AmlFilesystemHsmSettings withImportPrefixesInitial(List<String> importPrefixesInitial) {
        this.importPrefixesInitial = importPrefixesInitial;
        return this;
    }

    public void validate() {
        if (this.container() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property container in model AmlFilesystemHsmSettings"));
        }
        if (this.loggingContainer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property loggingContainer in model AmlFilesystemHsmSettings"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("container", this.container);
        jsonWriter.writeStringField("loggingContainer", this.loggingContainer);
        jsonWriter.writeStringField("importPrefix", this.importPrefix);
        jsonWriter.writeArrayField("importPrefixesInitial", this.importPrefixesInitial, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AmlFilesystemHsmSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AmlFilesystemHsmSettings)jsonReader.readObject(reader -> {
            AmlFilesystemHsmSettings deserializedAmlFilesystemHsmSettings = new AmlFilesystemHsmSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("container".equals(fieldName)) {
                    deserializedAmlFilesystemHsmSettings.container = reader.getString();
                    continue;
                }
                if ("loggingContainer".equals(fieldName)) {
                    deserializedAmlFilesystemHsmSettings.loggingContainer = reader.getString();
                    continue;
                }
                if ("importPrefix".equals(fieldName)) {
                    deserializedAmlFilesystemHsmSettings.importPrefix = reader.getString();
                    continue;
                }
                if ("importPrefixesInitial".equals(fieldName)) {
                    List importPrefixesInitial;
                    deserializedAmlFilesystemHsmSettings.importPrefixesInitial = importPrefixesInitial = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmlFilesystemHsmSettings;
        });
    }
}

