/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.fluent.models.AmlFilesystemInner;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemArchiveInfo;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemClientInfo;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemHealth;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemIdentity;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemPropertiesHsm;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemPropertiesMaintenanceWindow;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemRootSquashSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemUpdatePropertiesMaintenanceWindow;
import com.azure.resourcemanager.storagecache.models.SkuName;
import java.util.List;
import java.util.Map;

public interface AmlFilesystem {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public AmlFilesystemIdentity identity();

    public SkuName sku();

    public List<String> zones();

    public SystemData systemData();

    public float storageCapacityTiB();

    public AmlFilesystemHealth health();

    public AmlFilesystemProvisioningStateType provisioningState();

    public String filesystemSubnet();

    public AmlFilesystemClientInfo clientInfo();

    public Integer throughputProvisionedMBps();

    public AmlFilesystemEncryptionSettings encryptionSettings();

    public AmlFilesystemPropertiesMaintenanceWindow maintenanceWindow();

    public AmlFilesystemPropertiesHsm hsm();

    public AmlFilesystemRootSquashSettings rootSquashSettings();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public AmlFilesystemInner innerModel();

    public Update update();

    public AmlFilesystem refresh();

    public AmlFilesystem refresh(Context var1);

    public Response<Void> archiveWithResponse(AmlFilesystemArchiveInfo var1, Context var2);

    public void archive();

    public Response<Void> cancelArchiveWithResponse(Context var1);

    public void cancelArchive();

    public static interface UpdateStages {

        public static interface WithRootSquashSettings {
            public Update withRootSquashSettings(AmlFilesystemRootSquashSettings var1);
        }

        public static interface WithMaintenanceWindow {
            public Update withMaintenanceWindow(AmlFilesystemUpdatePropertiesMaintenanceWindow var1);
        }

        public static interface WithEncryptionSettings {
            public Update withEncryptionSettings(AmlFilesystemEncryptionSettings var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithEncryptionSettings,
    UpdateStages.WithMaintenanceWindow,
    UpdateStages.WithRootSquashSettings {
        public AmlFilesystem apply();

        public AmlFilesystem apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithRootSquashSettings {
            public WithCreate withRootSquashSettings(AmlFilesystemRootSquashSettings var1);
        }

        public static interface WithHsm {
            public WithCreate withHsm(AmlFilesystemPropertiesHsm var1);
        }

        public static interface WithMaintenanceWindow {
            public WithCreate withMaintenanceWindow(AmlFilesystemPropertiesMaintenanceWindow var1);
        }

        public static interface WithEncryptionSettings {
            public WithCreate withEncryptionSettings(AmlFilesystemEncryptionSettings var1);
        }

        public static interface WithFilesystemSubnet {
            public WithCreate withFilesystemSubnet(String var1);
        }

        public static interface WithStorageCapacityTiB {
            public WithCreate withStorageCapacityTiB(float var1);
        }

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithSku {
            public WithCreate withSku(SkuName var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(AmlFilesystemIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithSku,
        WithZones,
        WithStorageCapacityTiB,
        WithFilesystemSubnet,
        WithEncryptionSettings,
        WithMaintenanceWindow,
        WithHsm,
        WithRootSquashSettings {
            public AmlFilesystem create();

            public AmlFilesystem create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

