/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storagecache.fluent.StorageTargetsClient;
import com.azure.resourcemanager.storagecache.fluent.models.StorageTargetInner;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientImpl;
import com.azure.resourcemanager.storagecache.models.StorageTargetsResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class StorageTargetsClientImpl
implements StorageTargetsClient {
    private final StorageTargetsService service;
    private final StorageCacheManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTargetsClientImpl.class);

    StorageTargetsClientImpl(StorageCacheManagementClientImpl client) {
        this.service = (StorageTargetsService)RestProxy.create(StorageTargetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> dnsRefreshWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.dnsRefresh(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> dnsRefreshWithResponse(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.dnsRefreshSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> dnsRefreshWithResponse(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.dnsRefreshSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDnsRefreshAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.dnsRefreshWithResponseAsync(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDnsRefresh(String resourceGroupName, String cacheName, String storageTargetName) {
        Response<BinaryData> response = this.dnsRefreshWithResponse(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDnsRefresh(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        Response<BinaryData> response = this.dnsRefreshWithResponse(resourceGroupName, cacheName, storageTargetName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> dnsRefreshAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        return this.beginDnsRefreshAsync(resourceGroupName, cacheName, storageTargetName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void dnsRefresh(String resourceGroupName, String cacheName, String storageTargetName) {
        this.beginDnsRefresh(resourceGroupName, cacheName, storageTargetName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void dnsRefresh(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.beginDnsRefresh(resourceGroupName, cacheName, storageTargetName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTargetInner>> listByCacheSinglePageAsync(String resourceGroupName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByCache(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTargetsResult)res.getValue()).value(), ((StorageTargetsResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<StorageTargetInner> listByCacheAsync(String resourceGroupName, String cacheName) {
        return new PagedFlux(() -> this.listByCacheSinglePageAsync(resourceGroupName, cacheName), nextLink -> this.listByCacheNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<StorageTargetInner> listByCacheSinglePage(String resourceGroupName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<StorageTargetsResult> res = this.service.listByCacheSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTargetsResult)res.getValue()).value(), ((StorageTargetsResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<StorageTargetInner> listByCacheSinglePage(String resourceGroupName, String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<StorageTargetsResult> res = this.service.listByCacheSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTargetsResult)res.getValue()).value(), ((StorageTargetsResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StorageTargetInner> listByCache(String resourceGroupName, String cacheName) {
        return new PagedIterable(() -> this.listByCacheSinglePage(resourceGroupName, cacheName), nextLink -> this.listByCacheNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StorageTargetInner> listByCache(String resourceGroupName, String cacheName, Context context) {
        return new PagedIterable(() -> this.listByCacheSinglePage(resourceGroupName, cacheName, context), nextLink -> this.listByCacheNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName, String force) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, force, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String cacheName, String storageTargetName, String force) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, force, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String cacheName, String storageTargetName, String force, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, force, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName, String storageTargetName, String force) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cacheName, storageTargetName, force);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        String force = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cacheName, storageTargetName, force);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName, String storageTargetName, String force) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, cacheName, storageTargetName, force);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName, String storageTargetName) {
        String force = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, cacheName, storageTargetName, force);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName, String storageTargetName, String force, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, cacheName, storageTargetName, force, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String storageTargetName, String force) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, storageTargetName, force).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        String force = null;
        return this.beginDeleteAsync(resourceGroupName, cacheName, storageTargetName, force).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cacheName, String storageTargetName) {
        String force = null;
        this.beginDelete(resourceGroupName, cacheName, storageTargetName, force).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cacheName, String storageTargetName, String force, Context context) {
        this.beginDelete(resourceGroupName, cacheName, storageTargetName, force, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StorageTargetInner>> getWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StorageTargetInner> getAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        return this.getWithResponseAsync(resourceGroupName, cacheName, storageTargetName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((StorageTargetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageTargetInner> getWithResponse(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageTargetInner get(String resourceGroupName, String cacheName, String storageTargetName) {
        return (StorageTargetInner)((Object)this.getWithResponse(resourceGroupName, cacheName, storageTargetName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        if (storagetarget == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storagetarget is required and cannot be null."));
        }
        storagetarget.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, storagetarget, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        if (storagetarget == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagetarget is required and cannot be null."));
        }
        storagetarget.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, storagetarget, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        if (storagetarget == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storagetarget is required and cannot be null."));
        }
        storagetarget.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, storagetarget, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<StorageTargetInner>, StorageTargetInner> beginCreateOrUpdateAsync(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, cacheName, storageTargetName, storagetarget);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)StorageTargetInner.class), (Type)((Object)StorageTargetInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageTargetInner>, StorageTargetInner> beginCreateOrUpdate(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, cacheName, storageTargetName, storagetarget);
        return this.client.getLroResult(response, (Type)((Object)StorageTargetInner.class), (Type)((Object)StorageTargetInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageTargetInner>, StorageTargetInner> beginCreateOrUpdate(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, cacheName, storageTargetName, storagetarget, context);
        return this.client.getLroResult(response, (Type)((Object)StorageTargetInner.class), (Type)((Object)StorageTargetInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StorageTargetInner> createOrUpdateAsync(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, cacheName, storageTargetName, storagetarget).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageTargetInner createOrUpdate(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget) {
        return (StorageTargetInner)((Object)this.beginCreateOrUpdate(resourceGroupName, cacheName, storageTargetName, storagetarget).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageTargetInner createOrUpdate(String resourceGroupName, String cacheName, String storageTargetName, StorageTargetInner storagetarget, Context context) {
        return (StorageTargetInner)((Object)this.beginCreateOrUpdate(resourceGroupName, cacheName, storageTargetName, storagetarget, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreDefaultsWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreDefaults(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restoreDefaultsWithResponse(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.restoreDefaultsSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restoreDefaultsWithResponse(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.restoreDefaultsSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreDefaultsAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreDefaultsWithResponseAsync(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreDefaults(String resourceGroupName, String cacheName, String storageTargetName) {
        Response<BinaryData> response = this.restoreDefaultsWithResponse(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreDefaults(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        Response<BinaryData> response = this.restoreDefaultsWithResponse(resourceGroupName, cacheName, storageTargetName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restoreDefaultsAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        return this.beginRestoreDefaultsAsync(resourceGroupName, cacheName, storageTargetName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreDefaults(String resourceGroupName, String cacheName, String storageTargetName) {
        this.beginRestoreDefaults(resourceGroupName, cacheName, storageTargetName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreDefaults(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.beginRestoreDefaults(resourceGroupName, cacheName, storageTargetName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTargetInner>> listByCacheNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByCacheNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTargetsResult)res.getValue()).value(), ((StorageTargetsResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<StorageTargetInner> listByCacheNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<StorageTargetsResult> res = this.service.listByCacheNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTargetsResult)res.getValue()).value(), ((StorageTargetsResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<StorageTargetInner> listByCacheNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<StorageTargetsResult> res = this.service.listByCacheNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTargetsResult)res.getValue()).value(), ((StorageTargetsResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageCacheManagementClientStorageTargets")
    public static interface StorageTargetsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/dnsRefresh")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> dnsRefresh(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/dnsRefresh")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> dnsRefreshSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StorageTargetsResult>> listByCache(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<StorageTargetsResult> listByCacheSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @QueryParam(value="force") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @QueryParam(value="force") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StorageTargetInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<StorageTargetInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @BodyParam(value="application/json") StorageTargetInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @BodyParam(value="application/json") StorageTargetInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/restoreDefaults")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restoreDefaults(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/restoreDefaults")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> restoreDefaultsSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StorageTargetsResult>> listByCacheNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<StorageTargetsResult> listByCacheNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

