/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.StorageTargetOperationsClient;
import com.azure.resourcemanager.storagecache.models.StorageTargetOperations;

public final class StorageTargetOperationsImpl
implements StorageTargetOperations {
    private static final ClientLogger LOGGER = new ClientLogger(StorageTargetOperationsImpl.class);
    private final StorageTargetOperationsClient innerClient;
    private final StorageCacheManager serviceManager;

    public StorageTargetOperationsImpl(StorageTargetOperationsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void flush(String resourceGroupName, String cacheName, String storageTargetName) {
        this.serviceClient().flush(resourceGroupName, cacheName, storageTargetName);
    }

    @Override
    public void flush(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.serviceClient().flush(resourceGroupName, cacheName, storageTargetName, context);
    }

    @Override
    public void suspend(String resourceGroupName, String cacheName, String storageTargetName) {
        this.serviceClient().suspend(resourceGroupName, cacheName, storageTargetName);
    }

    @Override
    public void suspend(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.serviceClient().suspend(resourceGroupName, cacheName, storageTargetName, context);
    }

    @Override
    public void resume(String resourceGroupName, String cacheName, String storageTargetName) {
        this.serviceClient().resume(resourceGroupName, cacheName, storageTargetName);
    }

    @Override
    public void resume(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.serviceClient().resume(resourceGroupName, cacheName, storageTargetName, context);
    }

    @Override
    public void invalidate(String resourceGroupName, String cacheName, String storageTargetName) {
        this.serviceClient().invalidate(resourceGroupName, cacheName, storageTargetName);
    }

    @Override
    public void invalidate(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.serviceClient().invalidate(resourceGroupName, cacheName, storageTargetName, context);
    }

    private StorageTargetOperationsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }
}

