/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.models.StorageTargetInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.BlobNfsTarget;
import com.azure.resourcemanager.storagecache.models.ClfsTarget;
import com.azure.resourcemanager.storagecache.models.NamespaceJunction;
import com.azure.resourcemanager.storagecache.models.Nfs3Target;
import com.azure.resourcemanager.storagecache.models.OperationalStateType;
import com.azure.resourcemanager.storagecache.models.ProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.StorageTarget;
import com.azure.resourcemanager.storagecache.models.StorageTargetType;
import com.azure.resourcemanager.storagecache.models.UnknownTarget;
import java.util.Collections;
import java.util.List;

public final class StorageTargetImpl
implements StorageTarget,
StorageTarget.Definition,
StorageTarget.Update {
    private StorageTargetInner innerObject;
    private final StorageCacheManager serviceManager;
    private String resourceGroupName;
    private String cacheName;
    private String storageTargetName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<NamespaceJunction> junctions() {
        List<NamespaceJunction> inner = this.innerModel().junctions();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public StorageTargetType targetType() {
        return this.innerModel().targetType();
    }

    @Override
    public ProvisioningStateType provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public OperationalStateType state() {
        return this.innerModel().state();
    }

    @Override
    public Nfs3Target nfs3() {
        return this.innerModel().nfs3();
    }

    @Override
    public ClfsTarget clfs() {
        return this.innerModel().clfs();
    }

    @Override
    public UnknownTarget unknown() {
        return this.innerModel().unknown();
    }

    @Override
    public BlobNfsTarget blobNfs() {
        return this.innerModel().blobNfs();
    }

    @Override
    public Integer allocationPercentage() {
        return this.innerModel().allocationPercentage();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public StorageTargetInner innerModel() {
        return this.innerObject;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageTargetImpl withExistingCache(String resourceGroupName, String cacheName) {
        this.resourceGroupName = resourceGroupName;
        this.cacheName = cacheName;
        return this;
    }

    @Override
    public StorageTarget create() {
        this.innerObject = this.serviceManager.serviceClient().getStorageTargets().createOrUpdate(this.resourceGroupName, this.cacheName, this.storageTargetName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public StorageTarget create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStorageTargets().createOrUpdate(this.resourceGroupName, this.cacheName, this.storageTargetName, this.innerModel(), context);
        return this;
    }

    StorageTargetImpl(String name, StorageCacheManager serviceManager) {
        this.innerObject = new StorageTargetInner();
        this.serviceManager = serviceManager;
        this.storageTargetName = name;
    }

    @Override
    public StorageTargetImpl update() {
        return this;
    }

    @Override
    public StorageTarget apply() {
        this.innerObject = this.serviceManager.serviceClient().getStorageTargets().createOrUpdate(this.resourceGroupName, this.cacheName, this.storageTargetName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public StorageTarget apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStorageTargets().createOrUpdate(this.resourceGroupName, this.cacheName, this.storageTargetName, this.innerModel(), context);
        return this;
    }

    StorageTargetImpl(StorageTargetInner innerObject, StorageCacheManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.cacheName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "caches");
        this.storageTargetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storageTargets");
    }

    @Override
    public StorageTarget refresh() {
        this.innerObject = (StorageTargetInner)((Object)this.serviceManager.serviceClient().getStorageTargets().getWithResponse(this.resourceGroupName, this.cacheName, this.storageTargetName, Context.NONE).getValue());
        return this;
    }

    @Override
    public StorageTarget refresh(Context context) {
        this.innerObject = (StorageTargetInner)((Object)this.serviceManager.serviceClient().getStorageTargets().getWithResponse(this.resourceGroupName, this.cacheName, this.storageTargetName, context).getValue());
        return this;
    }

    @Override
    public void dnsRefresh() {
        this.serviceManager.storageTargets().dnsRefresh(this.resourceGroupName, this.cacheName, this.storageTargetName);
    }

    @Override
    public void dnsRefresh(Context context) {
        this.serviceManager.storageTargets().dnsRefresh(this.resourceGroupName, this.cacheName, this.storageTargetName, context);
    }

    @Override
    public StorageTargetImpl withJunctions(List<NamespaceJunction> junctions) {
        this.innerModel().withJunctions(junctions);
        return this;
    }

    @Override
    public StorageTargetImpl withTargetType(StorageTargetType targetType) {
        this.innerModel().withTargetType(targetType);
        return this;
    }

    @Override
    public StorageTargetImpl withState(OperationalStateType state) {
        this.innerModel().withState(state);
        return this;
    }

    @Override
    public StorageTargetImpl withNfs3(Nfs3Target nfs3) {
        this.innerModel().withNfs3(nfs3);
        return this;
    }

    @Override
    public StorageTargetImpl withClfs(ClfsTarget clfs) {
        this.innerModel().withClfs(clfs);
        return this;
    }

    @Override
    public StorageTargetImpl withUnknown(UnknownTarget unknown) {
        this.innerModel().withUnknown(unknown);
        return this;
    }

    @Override
    public StorageTargetImpl withBlobNfs(BlobNfsTarget blobNfs) {
        this.innerModel().withBlobNfs(blobNfs);
        return this;
    }
}

