/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.CachesClient;
import com.azure.resourcemanager.storagecache.fluent.models.CacheInner;
import com.azure.resourcemanager.storagecache.implementation.CacheImpl;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.Cache;
import com.azure.resourcemanager.storagecache.models.Caches;
import com.azure.resourcemanager.storagecache.models.PrimingJob;
import com.azure.resourcemanager.storagecache.models.PrimingJobIdParameter;
import com.azure.resourcemanager.storagecache.models.StorageTargetSpaceAllocation;
import java.util.List;

public final class CachesImpl
implements Caches {
    private static final ClientLogger LOGGER = new ClientLogger(CachesImpl.class);
    private final CachesClient innerClient;
    private final StorageCacheManager serviceManager;

    public CachesImpl(CachesClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Cache> list() {
        PagedIterable<CacheInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheImpl((CacheInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cache> list(Context context) {
        PagedIterable<CacheInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheImpl((CacheInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cache> listByResourceGroup(String resourceGroupName) {
        PagedIterable<CacheInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheImpl((CacheInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cache> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<CacheInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheImpl((CacheInner)((Object)inner1), this.manager()));
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String cacheName) {
        this.serviceClient().delete(resourceGroupName, cacheName);
    }

    @Override
    public void delete(String resourceGroupName, String cacheName, Context context) {
        this.serviceClient().delete(resourceGroupName, cacheName, context);
    }

    @Override
    public Response<Cache> getByResourceGroupWithResponse(String resourceGroupName, String cacheName, Context context) {
        Response<CacheInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, cacheName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CacheImpl((CacheInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Cache getByResourceGroup(String resourceGroupName, String cacheName) {
        CacheInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, cacheName);
        if (inner != null) {
            return new CacheImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void debugInfo(String resourceGroupName, String cacheName) {
        this.serviceClient().debugInfo(resourceGroupName, cacheName);
    }

    @Override
    public void debugInfo(String resourceGroupName, String cacheName, Context context) {
        this.serviceClient().debugInfo(resourceGroupName, cacheName, context);
    }

    @Override
    public void flush(String resourceGroupName, String cacheName) {
        this.serviceClient().flush(resourceGroupName, cacheName);
    }

    @Override
    public void flush(String resourceGroupName, String cacheName, Context context) {
        this.serviceClient().flush(resourceGroupName, cacheName, context);
    }

    @Override
    public void start(String resourceGroupName, String cacheName) {
        this.serviceClient().start(resourceGroupName, cacheName);
    }

    @Override
    public void start(String resourceGroupName, String cacheName, Context context) {
        this.serviceClient().start(resourceGroupName, cacheName, context);
    }

    @Override
    public void stop(String resourceGroupName, String cacheName) {
        this.serviceClient().stop(resourceGroupName, cacheName);
    }

    @Override
    public void stop(String resourceGroupName, String cacheName, Context context) {
        this.serviceClient().stop(resourceGroupName, cacheName, context);
    }

    @Override
    public void startPrimingJob(String resourceGroupName, String cacheName) {
        this.serviceClient().startPrimingJob(resourceGroupName, cacheName);
    }

    @Override
    public void startPrimingJob(String resourceGroupName, String cacheName, PrimingJob primingjob, Context context) {
        this.serviceClient().startPrimingJob(resourceGroupName, cacheName, primingjob, context);
    }

    @Override
    public void stopPrimingJob(String resourceGroupName, String cacheName) {
        this.serviceClient().stopPrimingJob(resourceGroupName, cacheName);
    }

    @Override
    public void stopPrimingJob(String resourceGroupName, String cacheName, PrimingJobIdParameter primingJobId, Context context) {
        this.serviceClient().stopPrimingJob(resourceGroupName, cacheName, primingJobId, context);
    }

    @Override
    public void pausePrimingJob(String resourceGroupName, String cacheName) {
        this.serviceClient().pausePrimingJob(resourceGroupName, cacheName);
    }

    @Override
    public void pausePrimingJob(String resourceGroupName, String cacheName, PrimingJobIdParameter primingJobId, Context context) {
        this.serviceClient().pausePrimingJob(resourceGroupName, cacheName, primingJobId, context);
    }

    @Override
    public void resumePrimingJob(String resourceGroupName, String cacheName) {
        this.serviceClient().resumePrimingJob(resourceGroupName, cacheName);
    }

    @Override
    public void resumePrimingJob(String resourceGroupName, String cacheName, PrimingJobIdParameter primingJobId, Context context) {
        this.serviceClient().resumePrimingJob(resourceGroupName, cacheName, primingJobId, context);
    }

    @Override
    public void upgradeFirmware(String resourceGroupName, String cacheName) {
        this.serviceClient().upgradeFirmware(resourceGroupName, cacheName);
    }

    @Override
    public void upgradeFirmware(String resourceGroupName, String cacheName, Context context) {
        this.serviceClient().upgradeFirmware(resourceGroupName, cacheName, context);
    }

    @Override
    public void spaceAllocation(String resourceGroupName, String cacheName) {
        this.serviceClient().spaceAllocation(resourceGroupName, cacheName);
    }

    @Override
    public void spaceAllocation(String resourceGroupName, String cacheName, List<StorageTargetSpaceAllocation> spaceAllocation, Context context) {
        this.serviceClient().spaceAllocation(resourceGroupName, cacheName, spaceAllocation, context);
    }

    @Override
    public Cache getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return (Cache)this.getByResourceGroupWithResponse(resourceGroupName, cacheName, Context.NONE).getValue();
    }

    @Override
    public Response<Cache> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, cacheName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        this.delete(resourceGroupName, cacheName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        this.delete(resourceGroupName, cacheName, context);
    }

    private CachesClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public CacheImpl define(String name) {
        return new CacheImpl(name, this.manager());
    }
}

