/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AutoImportJobPropertiesStatus;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesAdminStatus;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesProvisioningState;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesStatusBlobSyncEvents;
import com.azure.resourcemanager.storagecache.models.AutoImportJobState;
import com.azure.resourcemanager.storagecache.models.ConflictResolutionMode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class AutoImportJobProperties
implements JsonSerializable<AutoImportJobProperties> {
    private AutoImportJobPropertiesProvisioningState provisioningState;
    private AutoImportJobPropertiesAdminStatus adminStatus;
    private List<String> autoImportPrefixes;
    private ConflictResolutionMode conflictResolutionMode;
    private Boolean enableDeletions;
    private Long maximumErrors;
    private AutoImportJobPropertiesStatus innerStatus;

    public AutoImportJobPropertiesProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public AutoImportJobPropertiesAdminStatus adminStatus() {
        return this.adminStatus;
    }

    public AutoImportJobProperties withAdminStatus(AutoImportJobPropertiesAdminStatus adminStatus) {
        this.adminStatus = adminStatus;
        return this;
    }

    public List<String> autoImportPrefixes() {
        return this.autoImportPrefixes;
    }

    public AutoImportJobProperties withAutoImportPrefixes(List<String> autoImportPrefixes) {
        this.autoImportPrefixes = autoImportPrefixes;
        return this;
    }

    public ConflictResolutionMode conflictResolutionMode() {
        return this.conflictResolutionMode;
    }

    public AutoImportJobProperties withConflictResolutionMode(ConflictResolutionMode conflictResolutionMode) {
        this.conflictResolutionMode = conflictResolutionMode;
        return this;
    }

    public Boolean enableDeletions() {
        return this.enableDeletions;
    }

    public AutoImportJobProperties withEnableDeletions(Boolean enableDeletions) {
        this.enableDeletions = enableDeletions;
        return this;
    }

    public Long maximumErrors() {
        return this.maximumErrors;
    }

    public AutoImportJobProperties withMaximumErrors(Long maximumErrors) {
        this.maximumErrors = maximumErrors;
        return this;
    }

    private AutoImportJobPropertiesStatus innerStatus() {
        return this.innerStatus;
    }

    public AutoImportJobState state() {
        return this.innerStatus() == null ? null : this.innerStatus().state();
    }

    public String statusCode() {
        return this.innerStatus() == null ? null : this.innerStatus().statusCode();
    }

    public String statusMessage() {
        return this.innerStatus() == null ? null : this.innerStatus().statusMessage();
    }

    public OffsetDateTime scanStartTime() {
        return this.innerStatus() == null ? null : this.innerStatus().scanStartTime();
    }

    public OffsetDateTime scanEndTime() {
        return this.innerStatus() == null ? null : this.innerStatus().scanEndTime();
    }

    public Long totalBlobsWalked() {
        return this.innerStatus() == null ? null : this.innerStatus().totalBlobsWalked();
    }

    public Long rateOfBlobWalk() {
        return this.innerStatus() == null ? null : this.innerStatus().rateOfBlobWalk();
    }

    public Long totalBlobsImported() {
        return this.innerStatus() == null ? null : this.innerStatus().totalBlobsImported();
    }

    public Long rateOfBlobImport() {
        return this.innerStatus() == null ? null : this.innerStatus().rateOfBlobImport();
    }

    public Long importedFiles() {
        return this.innerStatus() == null ? null : this.innerStatus().importedFiles();
    }

    public Long importedDirectories() {
        return this.innerStatus() == null ? null : this.innerStatus().importedDirectories();
    }

    public Long importedSymlinks() {
        return this.innerStatus() == null ? null : this.innerStatus().importedSymlinks();
    }

    public Long preexistingFiles() {
        return this.innerStatus() == null ? null : this.innerStatus().preexistingFiles();
    }

    public Long preexistingDirectories() {
        return this.innerStatus() == null ? null : this.innerStatus().preexistingDirectories();
    }

    public Long preexistingSymlinks() {
        return this.innerStatus() == null ? null : this.innerStatus().preexistingSymlinks();
    }

    public Long totalErrors() {
        return this.innerStatus() == null ? null : this.innerStatus().totalErrors();
    }

    public Long totalConflicts() {
        return this.innerStatus() == null ? null : this.innerStatus().totalConflicts();
    }

    public AutoImportJobPropertiesStatusBlobSyncEvents blobSyncEvents() {
        return this.innerStatus() == null ? null : this.innerStatus().blobSyncEvents();
    }

    public OffsetDateTime lastStartedTimeUtc() {
        return this.innerStatus() == null ? null : this.innerStatus().lastStartedTimeUtc();
    }

    public OffsetDateTime lastCompletionTimeUtc() {
        return this.innerStatus() == null ? null : this.innerStatus().lastCompletionTimeUtc();
    }

    public void validate() {
        if (this.innerStatus() != null) {
            this.innerStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("adminStatus", this.adminStatus == null ? null : this.adminStatus.toString());
        jsonWriter.writeArrayField("autoImportPrefixes", this.autoImportPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("conflictResolutionMode", this.conflictResolutionMode == null ? null : this.conflictResolutionMode.toString());
        jsonWriter.writeBooleanField("enableDeletions", this.enableDeletions);
        jsonWriter.writeNumberField("maximumErrors", (Number)this.maximumErrors);
        return jsonWriter.writeEndObject();
    }

    public static AutoImportJobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AutoImportJobProperties)jsonReader.readObject(reader -> {
            AutoImportJobProperties deserializedAutoImportJobProperties = new AutoImportJobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedAutoImportJobProperties.provisioningState = AutoImportJobPropertiesProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("adminStatus".equals(fieldName)) {
                    deserializedAutoImportJobProperties.adminStatus = AutoImportJobPropertiesAdminStatus.fromString(reader.getString());
                    continue;
                }
                if ("autoImportPrefixes".equals(fieldName)) {
                    List autoImportPrefixes;
                    deserializedAutoImportJobProperties.autoImportPrefixes = autoImportPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("conflictResolutionMode".equals(fieldName)) {
                    deserializedAutoImportJobProperties.conflictResolutionMode = ConflictResolutionMode.fromString(reader.getString());
                    continue;
                }
                if ("enableDeletions".equals(fieldName)) {
                    deserializedAutoImportJobProperties.enableDeletions = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maximumErrors".equals(fieldName)) {
                    deserializedAutoImportJobProperties.maximumErrors = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAutoImportJobProperties.innerStatus = AutoImportJobPropertiesStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoImportJobProperties;
        });
    }
}

