/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.AutoExportStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class AutoExportJobPropertiesStatus
implements JsonSerializable<AutoExportJobPropertiesStatus> {
    private AutoExportStatusType state;
    private String statusCode;
    private String statusMessage;
    private Long totalFilesExported;
    private Long totalMiBExported;
    private Long totalFilesFailed;
    private Integer exportIterationCount;
    private OffsetDateTime lastSuccessfulIterationCompletionTimeUtc;
    private Long currentIterationFilesDiscovered;
    private Long currentIterationMiBDiscovered;
    private Long currentIterationFilesExported;
    private Long currentIterationMiBExported;
    private Long currentIterationFilesFailed;
    private OffsetDateTime lastStartedTimeUtc;
    private OffsetDateTime lastCompletionTimeUtc;

    public AutoExportStatusType state() {
        return this.state;
    }

    public AutoExportJobPropertiesStatus withState(AutoExportStatusType state) {
        this.state = state;
        return this;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Long totalFilesExported() {
        return this.totalFilesExported;
    }

    public Long totalMiBExported() {
        return this.totalMiBExported;
    }

    public Long totalFilesFailed() {
        return this.totalFilesFailed;
    }

    public Integer exportIterationCount() {
        return this.exportIterationCount;
    }

    public OffsetDateTime lastSuccessfulIterationCompletionTimeUtc() {
        return this.lastSuccessfulIterationCompletionTimeUtc;
    }

    public Long currentIterationFilesDiscovered() {
        return this.currentIterationFilesDiscovered;
    }

    public Long currentIterationMiBDiscovered() {
        return this.currentIterationMiBDiscovered;
    }

    public Long currentIterationFilesExported() {
        return this.currentIterationFilesExported;
    }

    public Long currentIterationMiBExported() {
        return this.currentIterationMiBExported;
    }

    public Long currentIterationFilesFailed() {
        return this.currentIterationFilesFailed;
    }

    public OffsetDateTime lastStartedTimeUtc() {
        return this.lastStartedTimeUtc;
    }

    public OffsetDateTime lastCompletionTimeUtc() {
        return this.lastCompletionTimeUtc;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static AutoExportJobPropertiesStatus fromJson(JsonReader jsonReader) throws IOException {
        return (AutoExportJobPropertiesStatus)jsonReader.readObject(reader -> {
            AutoExportJobPropertiesStatus deserializedAutoExportJobPropertiesStatus = new AutoExportJobPropertiesStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.state = AutoExportStatusType.fromString(reader.getString());
                    continue;
                }
                if ("statusCode".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.statusCode = reader.getString();
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.statusMessage = reader.getString();
                    continue;
                }
                if ("totalFilesExported".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.totalFilesExported = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalMiBExported".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.totalMiBExported = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalFilesFailed".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.totalFilesFailed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exportIterationCount".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.exportIterationCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lastSuccessfulIterationCompletionTimeUTC".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.lastSuccessfulIterationCompletionTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("currentIterationFilesDiscovered".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.currentIterationFilesDiscovered = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("currentIterationMiBDiscovered".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.currentIterationMiBDiscovered = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("currentIterationFilesExported".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.currentIterationFilesExported = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("currentIterationMiBExported".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.currentIterationMiBExported = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("currentIterationFilesFailed".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.currentIterationFilesFailed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lastStartedTimeUTC".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.lastStartedTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastCompletionTimeUTC".equals(fieldName)) {
                    deserializedAutoExportJobPropertiesStatus.lastCompletionTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoExportJobPropertiesStatus;
        });
    }
}

