/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AutoExportJobProperties;
import com.azure.resourcemanager.storagecache.models.AutoExportJobAdminStatus;
import com.azure.resourcemanager.storagecache.models.AutoExportJobProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.AutoExportStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class AutoExportJobInner
extends Resource {
    private AutoExportJobProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private AutoExportJobProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AutoExportJobInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AutoExportJobInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AutoExportJobProvisioningStateType provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public AutoExportJobAdminStatus adminStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().adminStatus();
    }

    public AutoExportJobInner withAdminStatus(AutoExportJobAdminStatus adminStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoExportJobProperties();
        }
        this.innerProperties().withAdminStatus(adminStatus);
        return this;
    }

    public List<String> autoExportPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().autoExportPrefixes();
    }

    public AutoExportJobInner withAutoExportPrefixes(List<String> autoExportPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoExportJobProperties();
        }
        this.innerProperties().withAutoExportPrefixes(autoExportPrefixes);
        return this;
    }

    public AutoExportStatusType state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public String statusCode() {
        return this.innerProperties() == null ? null : this.innerProperties().statusCode();
    }

    public String statusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().statusMessage();
    }

    public Long totalFilesExported() {
        return this.innerProperties() == null ? null : this.innerProperties().totalFilesExported();
    }

    public Long totalMiBExported() {
        return this.innerProperties() == null ? null : this.innerProperties().totalMiBExported();
    }

    public Long totalFilesFailed() {
        return this.innerProperties() == null ? null : this.innerProperties().totalFilesFailed();
    }

    public Integer exportIterationCount() {
        return this.innerProperties() == null ? null : this.innerProperties().exportIterationCount();
    }

    public OffsetDateTime lastSuccessfulIterationCompletionTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().lastSuccessfulIterationCompletionTimeUtc();
    }

    public Long currentIterationFilesDiscovered() {
        return this.innerProperties() == null ? null : this.innerProperties().currentIterationFilesDiscovered();
    }

    public Long currentIterationMiBDiscovered() {
        return this.innerProperties() == null ? null : this.innerProperties().currentIterationMiBDiscovered();
    }

    public Long currentIterationFilesExported() {
        return this.innerProperties() == null ? null : this.innerProperties().currentIterationFilesExported();
    }

    public Long currentIterationMiBExported() {
        return this.innerProperties() == null ? null : this.innerProperties().currentIterationMiBExported();
    }

    public Long currentIterationFilesFailed() {
        return this.innerProperties() == null ? null : this.innerProperties().currentIterationFilesFailed();
    }

    public OffsetDateTime lastStartedTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().lastStartedTimeUtc();
    }

    public OffsetDateTime lastCompletionTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().lastCompletionTimeUtc();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AutoExportJobInner fromJson(JsonReader jsonReader) throws IOException {
        return (AutoExportJobInner)((Object)jsonReader.readObject(reader -> {
            AutoExportJobInner deserializedAutoExportJobInner = new AutoExportJobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAutoExportJobInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAutoExportJobInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAutoExportJobInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAutoExportJobInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAutoExportJobInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAutoExportJobInner.innerProperties = AutoExportJobProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAutoExportJobInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoExportJobInner;
        }));
    }
}

