/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AmlFilesystemProperties;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemClientInfo;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemHealth;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemIdentity;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemPropertiesHsm;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemPropertiesMaintenanceWindow;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemRootSquashSettings;
import com.azure.resourcemanager.storagecache.models.SkuName;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AmlFilesystemInner
extends Resource {
    private AmlFilesystemIdentity identity;
    private SkuName sku;
    private List<String> zones;
    private AmlFilesystemProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public AmlFilesystemIdentity identity() {
        return this.identity;
    }

    public AmlFilesystemInner withIdentity(AmlFilesystemIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SkuName sku() {
        return this.sku;
    }

    public AmlFilesystemInner withSku(SkuName sku) {
        this.sku = sku;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public AmlFilesystemInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    private AmlFilesystemProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AmlFilesystemInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AmlFilesystemInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Float storageCapacityTiB() {
        return this.innerProperties() == null ? null : Float.valueOf(this.innerProperties().storageCapacityTiB());
    }

    public AmlFilesystemInner withStorageCapacityTiB(Float storageCapacityTiB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemProperties();
        }
        this.innerProperties().withStorageCapacityTiB(storageCapacityTiB.floatValue());
        return this;
    }

    public AmlFilesystemHealth health() {
        return this.innerProperties() == null ? null : this.innerProperties().health();
    }

    public AmlFilesystemProvisioningStateType provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String filesystemSubnet() {
        return this.innerProperties() == null ? null : this.innerProperties().filesystemSubnet();
    }

    public AmlFilesystemInner withFilesystemSubnet(String filesystemSubnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemProperties();
        }
        this.innerProperties().withFilesystemSubnet(filesystemSubnet);
        return this;
    }

    public AmlFilesystemClientInfo clientInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().clientInfo();
    }

    public Integer throughputProvisionedMBps() {
        return this.innerProperties() == null ? null : this.innerProperties().throughputProvisionedMBps();
    }

    public AmlFilesystemEncryptionSettings encryptionSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionSettings();
    }

    public AmlFilesystemInner withEncryptionSettings(AmlFilesystemEncryptionSettings encryptionSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemProperties();
        }
        this.innerProperties().withEncryptionSettings(encryptionSettings);
        return this;
    }

    public AmlFilesystemPropertiesMaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    public AmlFilesystemInner withMaintenanceWindow(AmlFilesystemPropertiesMaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemProperties();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public AmlFilesystemPropertiesHsm hsm() {
        return this.innerProperties() == null ? null : this.innerProperties().hsm();
    }

    public AmlFilesystemInner withHsm(AmlFilesystemPropertiesHsm hsm) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemProperties();
        }
        this.innerProperties().withHsm(hsm);
        return this;
    }

    public AmlFilesystemRootSquashSettings rootSquashSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().rootSquashSettings();
    }

    public AmlFilesystemInner withRootSquashSettings(AmlFilesystemRootSquashSettings rootSquashSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemProperties();
        }
        this.innerProperties().withRootSquashSettings(rootSquashSettings);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AmlFilesystemInner fromJson(JsonReader jsonReader) throws IOException {
        return (AmlFilesystemInner)((Object)jsonReader.readObject(reader -> {
            AmlFilesystemInner deserializedAmlFilesystemInner = new AmlFilesystemInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAmlFilesystemInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAmlFilesystemInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmlFilesystemInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAmlFilesystemInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAmlFilesystemInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedAmlFilesystemInner.identity = AmlFilesystemIdentity.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedAmlFilesystemInner.sku = SkuName.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedAmlFilesystemInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAmlFilesystemInner.innerProperties = AmlFilesystemProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAmlFilesystemInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmlFilesystemInner;
        }));
    }
}

